/* TrustedApplet.java */

import java.awt.*;
import java.applet.*;
import java.util.*;
import java.io.*;

public class TrustedApplet
extends Applet
{
  static final String ALLOWED_DIR = "c:\\tmp\\applets\\";
  static final String FNAME       = "TrustedApplet.log";
  static final String LOGMSG      = "Erzeugt von Applet: ";
  String msg;

  public void init()
  {
    msg = "Uninitialisiert";
    FileWriter out = null;
    try {
      //Ausgabedatei erzeugen
      out = new FileWriter(ALLOWED_DIR + FNAME);
      //Logmessage schreiben
      out.write(LOGMSG);
      //Zeitstempel schreiben
      GregorianCalendar cal = new GregorianCalendar();
      out.write(cal.get(Calendar.DATE) + ".");
      out.write((cal.get(Calendar.MONTH) + 1) + ".");
      out.write(cal.get(Calendar.YEAR) + " ");
      out.write(cal.get(Calendar.HOUR_OF_DAY) + ":");
      out.write(cal.get(Calendar.MINUTE) + ":");
      out.write(cal.get(Calendar.SECOND) + "");
      out.write(System.getProperty("line.separator"));
      //System-Properties lesen und in Datei schreiben
      out.write(getProp("user.name"));
      out.write(getProp("user.home"));
      out.write(getProp("user.dir"));
      //Datei schlieen
      msg = "Alle Sicherheitshuerden ueberwunden!";
    } catch (Exception e) {
      msg = e.toString();
    } finally {
      if (out != null) {
        try {
          out.close();
        } catch (IOException e) {
          //silently ignore
        }
      }
    }
  }

  public void paint(Graphics g)
  {
    g.drawString(msg, 20, 20);
  }

  private String getProp(String prop)
  {
    return prop + "=" +
           System.getProperty(prop) +
           System.getProperty("line.separator");
  }
}