/* TrivialObjectStore.java */

import java.io.*;
import java.util.*;

/**
 * Trivialer Objektspeicher, der Mengen von Name-Objekt-
 * Paaren aufnehmen und persistent speichern kann.
 */
public class TrivialObjectStore
{
  //Instance variables
  private String fname;
  private Hashtable objects;

  /**
   * Erzeugt einen neuen Objektspeicher mit dem angegebenen
   * Namen (die Erweiterung ".tos" ("trivial object store")
   * wird ggfs. automatisch angehngt.
   */
  public TrivialObjectStore(String fname)
  {
    this.fname = fname;
    if (!fname.endsWith(".tos")) {
      this.fname += ".tos";
    }
    this.objects = new Hashtable(50);
  }

  /**
   * Sichert den Objektspeicher unter dem im Konstruktor
   * angegebenen Namen.
   */
  public void save()
  throws IOException
  {
    FileOutputStream fs = new FileOutputStream(fname);
    ObjectOutputStream os = new ObjectOutputStream(fs);
    os.writeObject(objects);
    os.close();
  }

  /**
   * Ldt den Objektspeicher mit dem im Konstruktor
   * angegebenen Namen.
   */
  public void load()
  throws ClassNotFoundException, IOException
  {
    FileInputStream fs = new FileInputStream(fname);
    ObjectInputStream is = new ObjectInputStream(fs);
    objects = (Hashtable)is.readObject();
    is.close();
  }

  /**
   * Fgt ein Objekt in den Objektspeicher ein.
   */
  public void putObject(String name, Object object)
  {
    objects.put(name, object);
  }

  /**
   * Liest das Objekt mit dem angegebenen Namen aus dem
   * Objektspeicher. Ist es nicht vorhanden, wird null
   * zurckgegeben.
   */
  public Object getObject(String name)
  {
    return objects.get(name);
  }

  /**
   * Liefert eine Aufzhlung aller gespeicherten Namen.
   */
  public Enumeration getAllNames()
  {
    return objects.keys();
  }
}