/* TestFile.java */

import java.io.*;
import java.util.*;

public class TestFile
{
  public static void main(String[] args)
  {
    File fil = new File("TestFile.java");
    TestFile.printFileInfo(fil);
    fil = new File("..");
    TestFile.printFileInfo(fil);
  }

  static void printFileInfo(File fil)
  {
    System.out.println("Name= "+fil.getName());
    System.out.println("Path= "+fil.getPath());
    System.out.println("AbsolutePath= "+fil.getAbsolutePath());
    System.out.println("Parent= "+fil.getParent());
    System.out.println("exists= "+fil.exists());
    System.out.println("canWrite= "+fil.canWrite());
    System.out.println("canRead= "+fil.canRead());
    System.out.println("isFile= "+fil.isFile());
    System.out.println("isDirectory= "+fil.isDirectory());
    if (fil.isDirectory()) {
      String[] fils = fil.list();
      for (int i=0; i<fils.length; ++i) {
        System.out.println("  "+fils[i]);
      }
    }
    System.out.println("isAbsolute= "+fil.isAbsolute());
    System.out.println(
      "lastModified= "+(new Date(fil.lastModified()))
    );
    System.out.println("length= "+fil.length());
    System.out.println("");
  }
}