/* SplashScreen.java */

import javax.swing.*;
import javax.swing.border.*;
import java.awt.*;
import java.awt.event.*;

public class SplashScreen
extends JWindow
{
  public SplashScreen(String image, String text)
  {
    JPanel contentPane = new JPanel(); 
    contentPane.setLayout(new BorderLayout());
    Border bd1 = BorderFactory.createBevelBorder( 
      BevelBorder.RAISED
    );
    Border bd2 = BorderFactory.createEtchedBorder();
    Border bd3 = BorderFactory.createCompoundBorder(bd1, bd2);
    ((JPanel)contentPane).setBorder(bd3);
    ImageIcon icon = new ImageIcon(image);
    contentPane.add(new JLabel(" ", JLabel.CENTER), BorderLayout.NORTH);
    contentPane.add(new JLabel(icon, JLabel.CENTER), BorderLayout.CENTER);
    contentPane.add(new JLabel(text, JLabel.CENTER), BorderLayout.SOUTH);
    setContentPane(contentPane); 
  }

  public void showFor(int millis)
  {
    Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
    setLocation(dim.width / 3, dim.height / 3);
    setSize(dim.width / 3, dim.height / 3);
    setVisible(true);
    try {
      Thread.sleep(millis);
    } catch (InterruptedException e) {
    }
    setVisible(false);
  }

  public static void main(String[] args)
  {
    SplashScreen intro = new SplashScreen(
      "mine.gif",
      "(C) Copyright 2000, J. Krger, All Rights Reserved"
    );
    intro.showFor(3000);
    System.exit(0);
  }
}