/* SkyscraperApplet.java */

import java.awt.*;
import java.util.*;
import java.applet.*;

class Skyscraper
{
  public int x;
  public int y;
  public int width;
  public int height;
  int        wndcntx;
  int        wndcnty;
  boolean    blinkon = false;

  Skyscraper(int x, int y)
  {
    this.x = x;
    this.y = y;
    this.width = (int)(30*(0.5+Math.random()));
    this.height = (int)(100*(0.5+Math.random()));
    wndcntx = (width-4)/5;
    wndcnty = (height-4)/5;
  }

  void LightEvent(Graphics g)
  {
    double rnd  = Math.random();
    int    xwnd = (int)(Math.random()*wndcntx);
    int    ywnd = (int)(Math.random()*wndcnty);
    if (blinkon) {
      g.setColor(Color.black);
      g.fillRect(x+width/2,y-height-20,2,2);
      blinkon = false;
    }
    if (rnd >= 0.9) {
      blinkon = true;
      g.setColor(Color.red);
      g.fillRect(x+width/2,y-height-20,2,2);
    } else if (rnd >= 0.7) {
      g.setColor(Color.black);
      g.fillRect(x+2+xwnd*5,y-height+2+ywnd*5,2,2);
    } else {
      g.setColor(Color.yellow);
      g.fillRect(x+2+xwnd*5,y-height+2+ywnd*5,2,2);
    }
  }
}

public class SkyscraperApplet
extends Applet
implements Runnable
{
  //Membervariablen
  Thread th;
  Vector v = new Vector();
  AudioClip thunder;
  boolean running;

   //Parameter
  int    DELAY;
  float  FLASH;
  String THUNDER;

  public void init()
  {
    Skyscraper house;
    int x = 5;

    //Huser erzeugen
    while (this.getSize().width-x-1 >= 30) {
      house = new Skyscraper(x,this.getSize().height-10);
      v.addElement(house);
      x += house.width + 5;
    }
    setBackground(Color.black);

    //Parameter einlesen
    try {
      DELAY = Integer.parseInt(getParameter("delay"));
    } catch (NumberFormatException e) {
      DELAY = 75;
    }
    try {
      FLASH = (new Float(getParameter("flash"))).floatValue();
    } catch (NumberFormatException e) {
      FLASH = 0.01F;
    }
    THUNDER = getParameter("thunder");
    if (THUNDER != null) {
      thunder = getAudioClip(getCodeBase(),THUNDER);
    }
    System.out.println("DELAY = "+DELAY);
    System.out.println("FLASH = "+FLASH);
    System.out.println("THUNDER = "+THUNDER);
  }

  public void start()
  {
    if (th == null) {
      running = true;
      th = new Thread(this);
      th.start();
    }
  }

  public void stop()
  {
    if (th != null) {
      running = false;
      th = null;
    }
  }

  public void run()
  {
    while (running) {
      repaint();
      try {
        Thread.sleep(DELAY);
      } catch (InterruptedException e) {
        //nothing
      }
    }
  }

  public void update(Graphics g)
  {
    paint(g);
  }

  public void paint(Graphics g)
  {
    int i;
    Skyscraper house;

    i = (int)Math.floor(Math.random()*v.size());
    house = (Skyscraper)v.elementAt(i);
    house.LightEvent(g);
    if (Math.random() < FLASH) {
      Lightning(g,house.x+10,house.y-house.height);
    }
  }

  public void Lightning(Graphics g, int x, int y)
  {
    Vector poly = new Vector();
    int dx, dy, i, polysize;

    thunder.play();
    //Blitzpolygon berechnen
    poly.addElement(new Point(x,y));
    polysize = 1;
    while (y > 10) {
      dx = 10 - (int)(Math.floor(Math.random()*20));
      dy = - (int)(Math.floor(Math.random()*20));
      x += dx;
      y += dy;
      poly.addElement(new Point(x,y));
      ++polysize;
    }
    //Blitzvector in Koordinaten-Arrays umwandeln
    int[] xpoints = new int[poly.size()];
    int[] ypoints = new int[poly.size()];
    for (i = 0; i < polysize; ++i) {
      Point p = (Point)poly.elementAt(i);
      xpoints[i] = p.x;
      ypoints[i] = p.y;
    }
    //Blitz zeichnen
    for (i = 0; i <= 1; ++i) {
      g.setColor(Color.white);
      g.drawPolyline(xpoints, ypoints, polysize);
      try {
        Thread.sleep(20);
      } catch (InterruptedException e) {}
      g.setColor(Color.black);
      g.drawPolyline(xpoints, ypoints, polysize);
      try {
        Thread.sleep(20);
      } catch (InterruptedException e) {}
    }
  }
}