/* Scrollbar.inc */

public void adjustmentValueChanged(AdjustmentEvent event)
{
  Adjustable sb = event.getAdjustable();
  if (sb.getOrientation() == Scrollbar.HORIZONTAL) {
    System.out.print("Horizontal: ");
  } else {
    System.out.print("Vertikal: ");
  }
  switch (event.getAdjustmentType()) {
  case AdjustmentEvent.UNIT_INCREMENT:
    System.out.println("AdjustmentEvent.UNIT_INCREMENT");
    break;
  case AdjustmentEvent.UNIT_DECREMENT:
    System.out.println("AdjustmentEvent.UNIT_DECREMENT");
    break;
  case AdjustmentEvent.BLOCK_DECREMENT:
    System.out.println("AdjustmentEvent.BLOCK_DECREMENT");
    break;
  case AdjustmentEvent.BLOCK_INCREMENT:
    System.out.println("AdjustmentEvent.BLOCK_INCREMENT");
    break;
  case AdjustmentEvent.TRACK:
    System.out.println("AdjustmentEvent.TRACK");
    break;
  }
  System.out.println("  value: " + event.getValue());
}

private void customizeLayout(Panel panel)
{
   panel.setLayout(new BorderLayout());
   Scrollbar hsb=new Scrollbar(Scrollbar.HORIZONTAL,1,10,1,100);
   hsb.addAdjustmentListener(this);
   panel.add(hsb, BorderLayout.SOUTH);
   Scrollbar vsb=new Scrollbar(Scrollbar.VERTICAL,  1,10,1,100);
   vsb.addAdjustmentListener(this);
   panel.add(vsb, BorderLayout.EAST);
}