/* Queue.java */

import java.util.*;

/**
 * Das Interface der Queue-Collection.
 */
public interface Queue
{
  /**
   * Fgt das Element o am Ende der Queue an. Falls
   * keine Ausnahme ausgelst wurde, gibt die Methode
   * true zurck.
   */
  public boolean add(Object o);

  /**
   * Liefert das erste Element der Queue und entfernt es
   * daraus. Falls die Queue leer ist, wird eine Ausnahme
   * des Typs NoSuchElementException ausgelst.
   */
  public Object retrieve()
  throws NoSuchElementException;

  /**
   * Liefert die Anzahl der Elemente der Queue.
   */
  public int size();

  /**
   * Entfernt alle Elemente aus der Queue.
   */
  public void clear();

  /**
   * Liefert einen Iterator ber alle Elemente der Queue.
   */
  public Iterator iterator();
}