/* PrintableObject.java */

import java.lang.reflect.*;

public class PrintableObject
{
  public String toString()
  {
    StringBuffer sb = new StringBuffer(200);
    Class clazz = getClass();
    while (clazz != null) {
      Field[] fields = clazz.getDeclaredFields();
      for (int i = 0; i < fields.length; ++i) {
        sb.append(fields[i].getName() + " = ");
        try {
          Object obj = fields[i].get(this);
          if (obj.getClass().isArray()) {
            Object[] ar = (Object[])obj;
            for (int j = 0; j < ar.length; ++j) {
              sb.append(ar[j].toString() + " ");
            }
            sb.append("\n");
          } else {
            sb.append(obj.toString() + "\n");
          }
        } catch (IllegalAccessException e) {
          sb.append(e.toString() + "\n");
        }
      }
      clazz = clazz.getSuperclass();
    }
    return sb.toString();
  }

  public static void main(String[] args)
  {
    JavaProgrammer jim = new JavaProgrammer();
    jim.name           = "Jim Miller";
    jim.department     = "Operating Systems";
    jim.age            = 32;
    String[] langs     = {"C", "Pascal", "PERL", "Java"};
    jim.languages      = langs;
    jim.linesofcode    = 55000;
    jim.jdk12          = true;
    jim.swing          = false;
    System.out.println(jim);
  }
}

class Employee
extends PrintableObject
{
  public String name;
  public String department;
  public int    age;
}

class Programmer
extends Employee
{
  public String[] languages;
  public int      linesofcode;
}

class JavaProgrammer
extends Programmer
{
  public boolean jdk12;
  public boolean swing;
}