import java.util.*;

/**
 * Die folgende Klasse realisiert eine einfache Liste mit einer
 * festen Gre. Die Liste kann typisiert werden, so da
 * Zugriffs- und Hinzufgemethoden typsicher werden. Darber
 * hinaus implementiert sie das Interface Iterable und stellt
 * einen typsicheren Iterator zur Verfgung, um die Verwendung
 * in J2SE-5.0-foreach-Schleifen zu ermglichen.
 */
public class MiniListe<E>
implements Iterable<E>
{
  private Object[] data;
  private int      size;

  /**
   * Erzeugt eine leere Liste, die maximal maxSize Elemente
   * aufnehmen kann.
   */
  public MiniListe(int maxSize)
  {
    this.data = new Object[maxSize];
    this.size = 0;
  }

  /**
   * Fgt ein Element zur Liste hinzu. Falls diese schon
   * voll ist, wird eine Exception ausgelst.
   */
  public void addElement(E element)
  {
    if (size >= data.length) {
      throw new ArrayIndexOutOfBoundsException();
    }
    data[size++] = element;
  }

  /**
   * Liefert die Anzahl der Elemente in der Liste.
   */
  public int size()
  {
    return size;
  }

  /**
   * Liefert das Element an Position pos. Falls kein solches
   * Element vorhanden ist, wird eine Exception ausgelst.
   */
  public E elementAt(int pos)
  {
    if (pos >= size) {
      throw new NoSuchElementException();
    }
    return (E)data[pos];
  }

  /**
   * Liefert einen Iterator zum Durchlaufen der Elemente.
   */
  public Iterator<E> iterator()
  {
    return new Iterator<E>()
    {
      int pos = 0;

      public boolean hasNext()
      {
        return pos < size;
      }
      public E next()
      {
        if (pos >= size) {
          throw new NoSuchElementException();
        }
        return (E)data[pos++];
      }
      public void remove()
      {
        throw new UnsupportedOperationException();
      }
    };
  }

  //------------------------------------------
  public static void main(String[] args)
  {
    //Untypisierte Verwendung
    MiniListe l1 = new MiniListe(10);
    l1.addElement(3.14);
    l1.addElement("world");
    for (Object o : l1) {
      System.out.println(o);
    }
    //Ganzzahlige Typisierung
    System.out.println("---");
    MiniListe<Integer> l2 = new MiniListe<Integer>(5);
    l2.addElement(3);
    l2.addElement(1);
    l2.addElement(4);
    for (Integer i : l2) {
      System.out.println(i + 1000);
    }
    //Verwendung read-only
    System.out.println("---");
    MiniListe<? extends Number> l3 = l2;
    for (Number i : l3) {
      System.out.println(i.intValue() + 1000);
    }
  }
}