/* Listing4704.java */

import java.security.*;

public class Listing4704
{
  /**
   * Konvertiert ein Byte in einen Hex-String.
   */
  public static String toHexString(byte b)
  {
    int value = (b & 0x7F) + (b < 0 ? 128 : 0);
    String ret = (value < 16 ? "0" : "");
    ret += Integer.toHexString(value).toUpperCase();
    return ret;
  }

  public static void main(String[] args)
  {
    try {
      //Zufallszahlengenerator erstellen
      SecureRandom rand = SecureRandom.getInstance("SHA1PRNG");
      byte[] data = new byte[8];
      //Startwert initialisieren
      rand.setSeed(0x123456789ABCDEF0L);
      for (int i = 0; i < 10; ++i) {
        //Zufallszahlen berechnen
        rand.nextBytes(data);
        //Ausgeben
        for (int j = 0; j < 8; ++j) {
          System.out.print(toHexString(data[j]) + " ");
        }
        System.out.println();
      }
    } catch (Exception e) {
      System.err.println(e.toString());
      System.exit(1);
    }
  }
}