/* Listing4110.java */

import java.io.*;
import java.util.*;

public class Listing4110
{
  public static void main(String[] args)
  {
    //Erzeugen und Speichern des Objektspeichers
    TrivialObjectStore tos = new TrivialObjectStore("shop");
    tos.putObject("name", "Tami-Shop Norderelbe");
    tos.putObject("besitzer", "Meier, Fridolin");
    Vector products = new Vector(10);
    products.addElement("Dinky Dino");
    products.addElement("96er Classic");
    products.addElement("Black Frog");
    products.addElement("SmartGotchi");
    products.addElement("Pretty Dolly");
    tos.putObject("produkte", products);
    try {
      tos.save();
    } catch (IOException e) {
      System.err.println(e.toString());
    }

    //Einlesen des Objektspeichers 
    TrivialObjectStore tos2 = new TrivialObjectStore("shop");
    try {
      tos2.load();
      Enumeration names = tos2.getAllNames();
      while (names.hasMoreElements()) {
        String name = (String)names.nextElement();
        Object obj = tos2.getObject(name);
        System.out.print(name + ": ");
        System.out.println(obj.getClass().toString()); 
        if (obj instanceof Collection) {
          Iterator it = ((Collection)obj).iterator();
          while (it.hasNext()) {
            System.out.println("  " + it.next().toString());
          }
        } else {
          System.out.println("  " + obj.toString());
        }
      }
    } catch (IOException e) {
      System.err.println(e.toString());
    } catch (ClassNotFoundException e) {
      System.err.println(e.toString());
    }
  }
}