/* Listing3801.java */

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

public class Listing3801
extends JFrame
{
  public Listing3801()
  {
    super("JScrollPane");
    addWindowListener(new WindowClosingAdapter(true));
    //Dialogpanel erzeugen
    JPanel panel = new JPanel();
    panel.setLayout(new GridLayout(10, 10));
    for (int i = 1; i <= 100; ++i) {
      panel.add(new JCheckBox("Frage " + i));
    }
    //JScrollPane erzeugen
    JScrollPane scroll = new JScrollPane(panel);
    scroll.setCorner(
      JScrollPane.UPPER_RIGHT_CORNER,
      new JLabel("1", JLabel.CENTER)
    );
    scroll.setCorner(
      JScrollPane.LOWER_RIGHT_CORNER,
      new JLabel("2", JLabel.CENTER)
    );
    scroll.setColumnHeaderView(new ColumnHeader(panel, 10));
    //JScrollPane zur ContentPane hinzufgen
    getContentPane().add(scroll, BorderLayout.CENTER);
  }

  public static void main(String[] args)
  {
    Listing3801 frame = new Listing3801();
    frame.setLocation(100, 100);
    frame.setSize(300, 150);
    frame.setVisible(true);
  }
}

class ColumnHeader
extends JComponent
{
  JComponent component;
  int        columns;

  public ColumnHeader(JComponent component, int columns)
  {
    this.component = component;
    this.columns   = columns;
  }

  public void paintComponent(Graphics g)
  {
    int width = component.getSize().width;
    int height = getSize().height;
    int colwid = width / columns;
    for (int i = 0; i < columns; ++i) {
      g.setColor(i % 2 == 0 ? Color.yellow : Color.gray);
      g.fillRect(i * colwid, 0, colwid, height);
    }
    g.setColor(Color.black);
    g.drawLine(0, height - 1, width, height - 1);
  }

  public Dimension getPreferredSize()
  {
    return new Dimension(component.getSize().width, 20);
  }
}