/* Listing3712.java */

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

public class Listing3712
extends JFrame
implements AdjustmentListener
{
  private JPanel coloredPanel;
  private JScrollBar sbEast;
  private JScrollBar sbSouth;
  private int        blue = 0;
  private int        red = 0;

  public Listing3712()
  {
    super("JScrollBar");
    addWindowListener(new WindowClosingAdapter(true));
    Container cp = getContentPane();
    //Vertikaler Schieberegler
    sbEast = new JScrollBar(JScrollBar.VERTICAL, 0, 10, 0, 255);
    sbEast.addAdjustmentListener(this);
    cp.add(sbEast, BorderLayout.EAST);
    //Horizontaler Schieberegler
    sbSouth = new JScrollBar(JScrollBar.HORIZONTAL, 0, 10, 0, 255);
    sbSouth.addAdjustmentListener(this);
    cp.add(sbSouth, BorderLayout.SOUTH);
    //Farbiges Panel
    coloredPanel = new JPanel();
    coloredPanel.setBackground(new Color(red, 0, blue));
    cp.add(coloredPanel, BorderLayout.CENTER);
  }

  public void adjustmentValueChanged(AdjustmentEvent event)
  {
    JScrollBar sb = (JScrollBar)event.getSource();
    if (sb == sbEast) {
      blue = event.getValue();
    } else {
      red = event.getValue();
    }
    coloredPanel.setBackground(new Color(red, 0, blue));
    if (!sb.getValueIsAdjusting()) {
      System.out.println("(" + red + ",0," + blue + ")");
    }
  }

  public static void main(String[] args)
  {
    Listing3712 frame = new Listing3712();
    frame.setLocation(100, 100);
    frame.setSize(200, 200);
    frame.setVisible(true);
  }
}