/* Listing3608.java */

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

public class Listing3608
extends JFrame
implements ActionListener
{
  public Listing3608()
  {
    super("Swing-Mentest");
    addWindowListener(new WindowClosingAdapter(true));
    JMenuBar menubar = new JMenuBar();
    menubar.add(createFileMenu()); 
    setJMenuBar(menubar);
  }

  public void actionPerformed(ActionEvent event)
  {
    System.out.println(event.getActionCommand());
  }

  //---Private Methoden---------------
  private JMenu createFileMenu()
  {
    JMenu ret = new JMenu("Datei");
    ret.setMnemonic('D');
    JMenuItem mi;
    //ffnen
    mi = new JMenuItem("ffnen", 'f');
    setCtrlAccelerator(mi, 'O');
    mi.addActionListener(this);
    ret.add(mi);
    //Speichern
    mi = new JMenuItem("Speichern", 'p');
    setCtrlAccelerator(mi, 'S');
    mi.addActionListener(this);
    ret.add(mi);
    //Separator
    ret.addSeparator();
    //Beenden
    mi = new JMenuItem("Beenden", 'e');
    mi.addActionListener(this);
    ret.add(mi);
    return ret;
  }

  private void setCtrlAccelerator(JMenuItem mi, char acc)
  {
    KeyStroke ks = KeyStroke.getKeyStroke(
      acc, Event.CTRL_MASK
    );
    mi.setAccelerator(ks);
  }

  public static void main(String[] args)
  {
    Listing3608 frame = new Listing3608();
    frame.setLocation(100, 100);
    frame.setSize(300, 200);
    frame.setVisible(true);
  }
}