/* Listing3410.java */

import java.awt.*;
import java.awt.event.*;

public class Listing3410
extends Frame
implements Runnable
{
  //Konstanten
  private static final int NUMLEDS  = 20;
  private static final int SLEEP    = 60;
  private static final int LEDSIZE  = 10;
  private static final Color ONCOLOR  = new Color(255,0,0);
  private static final Color OFFCOLOR = new Color(100,0,0);

  //Instanzvariablen
  private Thread th;
  private int switched;
  private int dx;

  public static void main(String[] args)
  {
    Listing3410 frame = new Listing3410();
    frame.setSize(270,150);
    frame.setVisible(true);
    frame.startAnimation();
  }

  public Listing3410()
  {
    super("Leuchtdiodenkette");
    setBackground(Color.lightGray);
    addWindowListener(new WindowClosingAdapter(true));
  }

  public void startAnimation()
  {
    th = new Thread(this);
    th.start();
  }

  public void run()
  {
    switched = -1;
    dx = 1;
    while (true) {
      repaint();
      try {
        Thread.sleep(SLEEP);
      } catch (InterruptedException e){
        //nichts
      }
      switched += dx;
      if (switched < 0 || switched > NUMLEDS - 1) {
        dx = -dx;
        switched += 2*dx;
      }
    }
  }

  public void paint(Graphics g)
  {
    for (int i = 0; i < NUMLEDS; ++i) {
      g.setColor(i == switched ? ONCOLOR : OFFCOLOR);
      g.fillOval(10+i*(LEDSIZE+2),80,LEDSIZE,LEDSIZE);
    }
  }
}