/* Listing3216.java */

import java.awt.*;
import java.awt.event.*;

class NamedSystemColors
{
  String[]      names;
  SystemColor[] colors;

  public NamedSystemColors()
  {
    names  = new String[SystemColor.NUM_COLORS];
    colors = new SystemColor[SystemColor.NUM_COLORS];
    names [ 0] = "desktop";
    colors[ 0] = SystemColor.desktop;
    names [ 1]= "activeCaption";
    colors[ 1] = SystemColor.activeCaption;
    names [ 2] = "activeCaptionText";
    colors[ 2] = SystemColor.activeCaptionText;
    names [ 3] = "activeCaptionBorder";
    colors[ 3] = SystemColor.activeCaptionBorder;
    names [ 4] = "inactiveCaption";
    colors[ 4] = SystemColor.inactiveCaption;
    names [ 5] = "inactiveCaptionText";
    colors[ 5] = SystemColor.inactiveCaptionText;
    names [ 6] = "inactiveCaptionBorder";
    colors[ 6] = SystemColor.inactiveCaptionBorder;
    names [ 7] = "window";
    colors[ 7] = SystemColor.window;
    names [ 8] = "windowBorder";
    colors[ 8] = SystemColor.windowBorder;
    names [ 9] = "windowText";
    colors[ 9] = SystemColor.windowText;
    names [10] = "menu";
    colors[10] = SystemColor.menu;
    names [11] = "menuText";
    colors[11] = SystemColor.menuText;
    names [12] = "text";
    colors[12] = SystemColor.text;
    names [13] = "textText";
    colors[13] = SystemColor.textText;
    names [14] = "textHighlight";
    colors[14] = SystemColor.textHighlight;
    names [15] = "textHighlightText";
    colors[15] = SystemColor.textHighlightText;
    names [16] = "textInactiveText";
    colors[16] = SystemColor.textInactiveText;
    names [17] = "control";
    colors[17] = SystemColor.control;
    names [18] = "controlText";
    colors[18] = SystemColor.controlText;
    names [19] = "controlHighlight";
    colors[19] = SystemColor.controlHighlight;
    names [20] = "controlLtHighlight";
    colors[20] = SystemColor.controlLtHighlight;
    names [21] = "controlShadow";
    colors[21] = SystemColor.controlShadow;
    names [22] = "controlDkShadow";
    colors[22] = SystemColor.controlDkShadow;
    names [23] = "scrollbar";
    colors[23] = SystemColor.scrollbar;
    names [24] = "info";
    colors[24] = SystemColor.info;
    names [25] = "infoText";
    colors[25] = SystemColor.infoText;
  }

  public int getSize()
  {
    return SystemColor.NUM_COLORS;
  }

  public String getName(int i)
  {
    return names[i];
  }

  public SystemColor getColor(int i)
  {
    return colors[i];
  }
}

class SystemColorViewer
extends Canvas
{
  NamedSystemColors colors;

  public SystemColorViewer()
  {
    colors = new NamedSystemColors();
  }

  public Dimension getPreferredSize()
  {
    return new Dimension(150,16 + colors.getSize() * 20);
  }

  public void paint(Graphics g)
  {
    for (int i = 0; i < colors.getSize(); ++i) {
      //Rahmen fr Farbbox
      g.setColor(Color.black);
      g.drawRect(10,16+20*i,16,16);
      //Farbbox
      g.setColor(colors.getColor(i));
      g.fillRect(11,17+20*i,15,15);
      //Bezeichnung
      g.setColor(Color.black);
      g.drawString(colors.getName(i),30,30+20*i);
    }
  }
}

public class Listing3216
extends Frame
{
  public static void main(String[] args)
  {
    Listing3216 wnd = new Listing3216();
    wnd.setLocation(200,100);
    wnd.setVisible(true);
  }

  public Listing3216()
  {
    super("ScrollPane");
    setBackground(Color.lightGray);
    //ScrollPane
    ScrollPane sc = new ScrollPane(
       ScrollPane.SCROLLBARS_AS_NEEDED
    );
    sc.add(new SystemColorViewer());
    sc.getVAdjustable().setUnitIncrement(1);
    sc.getHAdjustable().setUnitIncrement(1);
    sc.setSize(200,200);
    add(sc);
    //Window-Listener
    addWindowListener(new WindowClosingAdapter(true));
    //Dialogelement anordnen
    pack();
  }
}