/* Listing3111.java */

import java.awt.*;
import java.awt.event.*;
import java.util.*;

class ModalDialog
extends Dialog
implements ActionListener
{
  String result;

  public static String OKDialog(Frame owner, String msg)
  {
    ModalDialog dlg;
    dlg = new ModalDialog(owner,"Nachricht",msg,"OK");
    dlg.setVisible(true);
    return dlg.getResult();
  }

  public static String YesNoDialog(Frame owner, String msg)
  {
    ModalDialog dlg;
    dlg = new ModalDialog(owner,"Frage",msg,"Ja,Nein");
    dlg.setVisible(true);
    return dlg.getResult();
  }

  public static String YesNoCancelDialog(Frame owner,String msg)
  {
    ModalDialog dlg;
    dlg = new ModalDialog(owner,"Frage",msg,"Ja,Nein,Abbruch");
    dlg.setVisible(true);
    return dlg.getResult();
  }

  public ModalDialog(
    Frame owner,
    String title,
    String msg,
    String buttons
  )
  {
    super(owner, title, true);
    //Fenster
    setBackground(Color.lightGray);
    setLayout(new BorderLayout());
    setResizable(false);
    Point parloc = owner.getLocation();
    setLocation(parloc.x + 30, parloc.y + 30);
    //Message
    add(new Label(msg), BorderLayout.CENTER);
    //Buttons
    Panel panel = new Panel();
    panel.setLayout(new FlowLayout(FlowLayout.CENTER));
    StringTokenizer strtok = new StringTokenizer(buttons,",");
    while (strtok.hasMoreTokens()) {
      Button button = new Button(strtok.nextToken());
      button.addActionListener(this);
      panel.add(button);
    }
    add(panel, BorderLayout.SOUTH);
    pack();
  }

  public void actionPerformed(ActionEvent event)
  {
    result = event.getActionCommand();
    setVisible(false);
    dispose();
  }

  public String getResult()
  {
    return result;
  }
}

public class Listing3111
extends Frame
implements ActionListener
{
  public static void main(String[] args)
  {
    Listing3111 wnd = new Listing3111();
    wnd.setVisible(true);
  }

  public Listing3111()
  {
    super("Drei modale Standarddialoge");
    setLayout(new FlowLayout());
    setBackground(Color.lightGray);
    Button button = new Button("OKDialog");
    button.addActionListener(this);
    add(button);
    button = new Button("YesNoDialog");
    button.addActionListener(this);
    add(button);
    button = new Button("YesNoCancelDialog");
    button.addActionListener(this);
    add(button);
    setLocation(100,100);
    setSize(400,200);
    setVisible(true);
  }

  public void actionPerformed(ActionEvent event)
  {
    String cmd = event.getActionCommand();
    if (cmd.equals("OKDialog")) {
      ModalDialog.OKDialog(this,"Dream, dream, dream, ...");
    } else if (cmd.equals("YesNoDialog")) {
      String ret = ModalDialog.YesNoDialog(
        this,
        "Programm beenden?"
      );
      if (ret.equals("Ja")) {
        setVisible(false);
        dispose();
        System.exit(0);
      }
    } else if (cmd.equals("YesNoCancelDialog")) {
      String msg = "Verzeichnis erstellen?";
      String ret = ModalDialog.YesNoCancelDialog(this,msg);
      ModalDialog.OKDialog(this,"Rckgabe: " + ret);
    }
  }
}