/* Listing3001.java */

import java.awt.*;
import java.awt.event.*;

class MainMenu1
extends MenuBar
{
  private MenuItem miRueck;
  private CheckboxMenuItem miFarbe;

  public MainMenu1()
  {
    Menu m;

    //Datei
    m = new Menu("Datei");
    m.add(new MenuItem("Neu"));
    m.add(new MenuItem("Laden"));
    m.add(new MenuItem("Speichern"));
    m.addSeparator();
    m.add(new MenuItem("Beenden"));
    add(m);
    //Bearbeiten
    m = new Menu("Bearbeiten");
    m.add((miRueck = new MenuItem("Rueckgaengig")));
    m.addSeparator();
    m.add(new MenuItem("Ausschneiden"));
    m.add(new MenuItem("Kopieren"));
    m.add(new MenuItem("Einfuegen"));
    m.add(new MenuItem("Loeschen"));
    add(m);
    //Optionen
    m = new Menu("Optionen");
    m.add(new MenuItem("Einstellungen"));
    m.add((miFarbe = new CheckboxMenuItem("Farbe")));
    add(m);
    //Rueckgaengig deaktivieren
    enableRueckgaengig(false);
    //Farbe anschalten
    setFarbe(true);
  }

  public void enableRueckgaengig(boolean ena)
  {
    if (ena) {
      miRueck.setEnabled(true);
    } else {
      miRueck.setEnabled(false);
    }
  }

  public void setFarbe(boolean on)
  {
    miFarbe.setState(on);
  }
}

public class Listing3001
extends Frame
{
  public static void main(String[] args)
  {
    Listing3001 wnd = new Listing3001();
  }

  public Listing3001()
  {
    super("Mens");
    setLocation(100,100);
    setSize(400,300);
    setMenuBar(new MainMenu1());
    setVisible(true);
    addWindowListener(new WindowClosingAdapter(true));
  }
}