/* Listing2904.java */

import java.awt.*;
import java.awt.event.*;
import java.util.*;

public class Listing2904
extends Frame
{
  private Vector drawlist;
  private Rectangle actrect;

  public static void main(String[] args)
  {
    Listing2904 wnd = new Listing2904();
    wnd.setLocation(200,200);
    wnd.setSize(400,300);
    wnd.setVisible(true);
  }

  public Listing2904()
  {
    super("Rechtecke zeichnen");
    drawlist = new Vector();
    actrect = new Rectangle(0,0,0,0);
    addWindowListener(new MyWindowListener());
    addMouseListener(new MyMouseListener());
    addMouseMotionListener(new MyMouseMotionListener());
  }

  public void paint(Graphics g)
  {
    Rectangle r;
    Enumeration e;

    for (e = drawlist.elements(); e.hasMoreElements(); ) {
      r = (Rectangle)e.nextElement();
      g.drawRect(r.x, r.y, r.width, r.height);
    }
    if (actrect.x > 0 || actrect.y > 0) {
      g.drawRect(
        actrect.x,
        actrect.y,
        actrect.width,
        actrect.height
      );
    }
  }

  class MyMouseListener
  extends MouseAdapter
  {
    public void mousePressed(MouseEvent event)
    {
      actrect = new Rectangle(event.getX(),event.getY(),0,0);
    }

    public void mouseReleased(MouseEvent event)
    {
      if (actrect.width > 0 || actrect.height > 0) {
        drawlist.addElement(actrect);
      }
      repaint();
    }
  }

  class MyMouseMotionListener
  extends MouseMotionAdapter
  {
    public void mouseDragged(MouseEvent event)
    {
      int x = event.getX();
      int y = event.getY();
      if (x > actrect.x && y > actrect.y) {
        actrect.width = x - actrect.x;
        actrect.height = y - actrect.y;
      }
      repaint();
    }
  }

  class MyWindowListener
  extends WindowAdapter
  {
    public void windowClosing(WindowEvent event)
    {
      setVisible(false);
      dispose();
      System.exit(0);
    }
  }
}