/* Listing2902.java */

import java.awt.*;
import java.awt.event.*;

class ComponentRepaintAdapter
extends ComponentAdapter
{
  public void componentMoved(ComponentEvent event)
  {
    event.getComponent().repaint();
  }

  public void componentResized(ComponentEvent event)
  {
    event.getComponent().repaint();
  }
}

class BirdsEyeFrame
extends Frame
{
  public BirdsEyeFrame()
  {
    super("BirdsEyeFrame");
    addWindowListener(new WindowClosingAdapter(true));
    addComponentListener(new ComponentRepaintAdapter());
    setBackground(Color.lightGray);
  }

  public void paint(Graphics g)
  {
    Dimension screensize = getToolkit().getScreenSize();
    Dimension framesize  = getSize();
    double qx = framesize.width  / (double)screensize.width;
    double qy = framesize.height / (double)screensize.height;
    g.setColor(Color.white);
    g.fillRect(
      (int)(qx * getLocation().x),
      (int)(qy * getLocation().y),
      (int)(qx * framesize.width),
      (int)(qy * framesize.height)
    );
    g.setColor(Color.darkGray);
    g.fillRect(
      (int)(qx * getLocation().x),
      (int)(qy * getLocation().y),
      (int)(qx * framesize.width),
      (int)(qy * getInsets().top)
    );
    g.drawRect(
      (int)(qx * getLocation().x),
      (int)(qy * getLocation().y),
      (int)(qx * framesize.width),
      (int)(qy * framesize.height)
    );
  }
}

public class Listing2902
{
  public static void main(String[] args)
  {
    BirdsEyeFrame wnd = new BirdsEyeFrame();
    wnd.setSize(300,200);
    wnd.setLocation(200,100);
    wnd.setVisible(true);
  }
}