/* Listing2604.java */

import java.util.*;
import java.io.*;
import javax.comm.*;

public class Listing2604
{
  public static void printHello(Writer out)
  throws IOException
  {
    String s = "Hello LPT1 World";
    s += " " + s + " " + s;
    for (int i = 1; i <= 50; ++i) {
      out.write(s.substring(0, i) + "\r\n");
    }
    out.write("\f");
  }

  public static void main(String[] args)
  {
    Enumeration en = CommPortIdentifier.getPortIdentifiers();
    while (en.hasMoreElements()) {
      CommPortIdentifier cpi = (CommPortIdentifier)en.nextElement();
      if (cpi.getPortType() == CommPortIdentifier.PORT_PARALLEL) {
        if (cpi.getName().equals("LPT1")) {
          try {
            ParallelPort lpt1 = (ParallelPort)cpi.open(
              "LPT1Test",
              1000
            );
            OutputStreamWriter out = new OutputStreamWriter(
              lpt1.getOutputStream()
            );
            printHello(out);
            out.close();
            lpt1.close();
            System.exit(0);
          } catch (PortInUseException e) {
            System.err.println(e.toString());
            System.exit(1);
          } catch (IOException e) {
            System.err.println(e.toString());
            System.exit(1);
          }
        }
      }
    }
  }
}