/* Listing2601.java */

import java.awt.*;
import java.awt.event.*;

public class Listing2601
extends Frame
{
  public static void main(String[] args)
  {
    Listing2601 wnd = new Listing2601();
  }

  public Listing2601()
  {
    super("Drucken");
    addWindowListener(new WindowClosingAdapter(true));
    setBackground(Color.lightGray);
    setSize(400,400);
    setVisible(true);
    //Ausdruck in 2 Sekunden starten
    try {
      Thread.sleep(2000);
    } catch (InterruptedException e) {
      //nichts
    }
    printTestPage();
  }

  public void paint(Graphics g)
  {
    paintGrayBoxes(g, 40, 50);
  }

  public void printTestPage()
  {
    PrintJob pjob = getToolkit().getPrintJob(
      this,
      "Testseite",
      null
    );
    if (pjob != null) {
      //Metriken
      int pres = pjob.getPageResolution();
      int sres = getToolkit().getScreenResolution();
      Dimension d2 = new Dimension(
        (int)(((21.0 - 2.0) / 2.54) * sres),
        (int)(((29.7 - 2.0) / 2.54) * sres)
      );
      //Ausdruck beginnt
      Graphics pg = pjob.getGraphics();
      if (pg != null) {
        //Rahmen
        pg.drawRect(0, 0, d2.width, d2.height);
        //Text
        pg.setFont(new Font("TimesRoman",Font.PLAIN,24));
        pg.drawString("Testseite",40,70);
        pg.drawString(
          "Druckerauflsung : " + pres + " dpi",
          40,
          100
        );
        pg.drawString(
          "Bildschirmauflsung : " + sres + " dpi",
          40,
          130
        );
        pg.drawString(
          "Seitengre : " + d2.width + " * " + d2.height,
          40,
          160
        );
        //Graustufenkstchen
        paintGrayBoxes(pg, 40, 200);
        //Seite ausgeben
        pg.dispose();
      }
      pjob.end();
    }
  }

  private void paintGrayBoxes(Graphics g, int x, int y)
  {
    for (int i = 0; i < 16; ++i) {
      for (int j = 0; j < 16; ++j) {
        int level = 16 * i + j;
        g.setColor(Color.black);
        g.drawRect(x + 20 * j, y + 20 * i, 20, 20);
        g.setColor(new Color(level, level, level));
        g.fillRect(x + 1 + 20 * j, y + 1 + 20 * i, 19, 19);
      }
    }
  }
}