/* Listing2105.java */

import java.io.*;

public class Listing2105
{
  static void traverse(File dir, DirectoryVisitor visitor)
  {
    if (!dir.isDirectory()) {
      throw new IllegalArgumentException(
        "not a directory: " + dir.getName()
      );
    }
    visitor.enterDirectory(dir);
    File[] entries = dir.listFiles(
      new FileFilter()
      {
        public boolean accept(File pathname)
        {
          return true;
        }
      }
    );
    for (int i = 0; i < entries.length; ++i) {
      if (entries[i].isDirectory()) {
        traverse(entries[i], visitor);
      } else {
        visitor.visitFile(entries[i]);
      }
    }
    visitor.leaveDirectory(dir);
  }

  public static void main(String[] args)
  {
    File file = new File(args[0]);
    //Bildschirmausgabe der Struktur
    traverse(file, new DirectoryPrintVisitor());
    //Gren ermitteln
    DirectorySizeVisitor visitor = new DirectorySizeVisitor();
    traverse(file, visitor);
    System.out.println("directories: " + visitor.getDirs());
    System.out.println("files: "       + visitor.getFiles());
    System.out.println("size: "        + visitor.getSize());
  }
}