/* Listing1805.java */

import java.io.*;

class UpCaseWriter
extends FilterWriter
{
  public UpCaseWriter(Writer out)
  {
    super(out);
  }

  public void write(int c)
  throws IOException
  {
    super.write(Character.toUpperCase((char)c));
  }

  public void write(char[] cbuf, int off, int len)
  throws IOException
  {
    for (int i = 0; i < len; ++i) {
      write(cbuf[off + i]);
    }
  }

  public void write(String str, int off, int len)
  throws IOException
  {
    write(str.toCharArray(), off, len);
   }
}

public class Listing1805
{
   public static void main(String[] args)
   {
      PrintWriter f;
      String s = "und dieser String auch";

      try {
         f = new PrintWriter(
             new UpCaseWriter(
             new FileWriter("upcase.txt")));
         //Aufruf von auen
         f.println("Diese Zeile wird schn gro geschrieben");
         //Test von write(int)
         f.write('a');
         f.println();
         //Test von write(String)
         f.write(s);
         f.println();
         //Test von write(String, int, int)
         f.write(s,0,17);
         f.println();
         //Test von write(char[], int, int)
         f.write(s.toCharArray(),0,10);
         f.println();
         //---
         f.close();
      } catch (IOException e) {
         System.out.println("Fehler beim Erstellen der Datei");
      }
   }
}