/* LightBulbLightOnEditor3.java */

import java.awt.*;
import java.awt.event.*;
import java.beans.*;

public class LightBulbLightOnEditor3
extends PropertyEditorSupport
{
  boolean currentvalue;

  public void setValue(Object value)
  {
    currentvalue = ((Boolean)value).booleanValue();
  }

  public Object getValue()
  {
    return new Boolean(currentvalue);
  }

  public boolean isPaintable()
  {
    return true;
  }

  public boolean supportsCustomEditor()
  {
    return true;
  }

  public Component getCustomEditor()
  {
    return new LightOnCustomEditor();
  }

  public void paintValue(Graphics g, Rectangle box)
  {
    //Linke Box: blau, Lampe ausgeschaltet
    g.setColor(Color.blue);
    g.fillRect(box.x, box.y, box.width / 2, box.height);
    //Rechte Box: blau, Lampe angeschaltet
    g.setColor(Color.yellow);
    g.fillRect(box.x + box.width / 2, box.y, box.width / 2, box.height);
    //Rahmen
    g.setColor(Color.black);
    for (int i = 0; i < 2; ++i) {
      g.drawRect(
        box.x + (currentvalue ? box.width / 2 : 0) + i,
        box.y + i,
        box.width / 2 - 1 - (2 * i),
        box.height - 1 - (2 * i)
      );
    }
  }

  //---Private Klassen----------------------------------------
  class LightOnCustomEditor
  extends Canvas
  {
    public LightOnCustomEditor()
    {
      addMouseListener(
        new MouseAdapter() {
          public void mouseClicked(MouseEvent event)
            {
              currentvalue = (event.getX() > getSize().width / 2);
              LightBulbLightOnEditor3.this.firePropertyChange();
              repaint();
            }
          }
        );
    }

    public void paint(Graphics g)
    {
      paintValue(g, new Rectangle(0, 0, getSize().width, getSize().height));
    }

    public Dimension getPreferredSize()
    {
      return new Dimension(120, 60);
    }
  }
}