/* LightBulbBeanInfo.java */

import java.awt.*;
import java.beans.*;
import java.lang.reflect.*;

public class LightBulbBeanInfo
extends SimpleBeanInfo
{
  public Image getIcon(int iconKind)
  {
    String imgname = "bulbico16.gif";
    if (iconKind == BeanInfo.ICON_MONO_32x32 ||
        iconKind == BeanInfo.ICON_COLOR_32x32) {
      imgname = "bulbico32.gif";
    }
    return loadImage(imgname);
  }

  public PropertyDescriptor[] getPropertyDescriptors()
  {
    try {
      PropertyDescriptor pd1 = new PropertyDescriptor(
        "lightOn",
        LightBulb.class
      );
      //pd1.setPropertyEditorClass(LightBulbLightOnEditor1.class); 
      PropertyDescriptor[] ret = {pd1};
      return ret;
    } catch (IntrospectionException e) {
      System.err.println(e.toString());
      return null;
    }
  }

  public MethodDescriptor[] getMethodDescriptors()
  {
    MethodDescriptor[] ret = null;
    try {
      Class bulbclass = LightBulb.class;
      Method meth1 = bulbclass.getMethod("toggleLight", null);
      ret = new MethodDescriptor[1];
      ret[0] = new MethodDescriptor(meth1);
    } catch (NoSuchMethodException e) {
      //ret bleibt null
    }
    return ret;
  }
}