/* ImageResource.inc */

import java.io.*;
import java.awt.*;

//...

public Image loadImageResource(String pkgname, String fname)
throws IOException
{
  Image ret = null;
  InputStream is = getResourceStream(pkgname, fname);
  if (is != null) {
    byte[] buffer = new byte[0];
    byte[] tmpbuf = new byte[1024];
    while (true) {
      int len = is.read(tmpbuf);
      if (len <= 0) {
        break;
      }
      byte[] newbuf = new byte[buffer.length + len];
      System.arraycopy(buffer, 0, newbuf, 0, buffer.length);
      System.arraycopy(tmpbuf, 0, newbuf, buffer.length, len);
      buffer = newbuf;
    }
    //create image
    ret = Toolkit.getDefaultToolkit().createImage(buffer);
    is.close();
  }
  return ret;
}

//...