/* FloatTables.java */

import java.lang.reflect.*;

public class FloatTables
{
  public static double times2(double value)
  {
    return 2 * value;
  }

  public static double sqr(double value)
  {
    return value * value;
  }

  public static void printTable(String methname)
  {
    try {
      System.out.println("Wertetabelle fuer " + methname);
      int pos = methname.lastIndexOf('.'); 
      Class clazz;
      if (pos == -1) {
        clazz = FloatTables.class;
      } else {
        clazz = Class.forName(methname.substring(0, pos));
        methname = methname.substring(pos + 1);
      }
      Class[] formparas = new Class[1];
      formparas[0] = Double.TYPE;
      Method meth = clazz.getMethod(methname, formparas);
      if (!Modifier.isStatic(meth.getModifiers())) {
        throw new Exception(methname + " ist nicht static");
      }
      Object[] actargs = new Object[1];
      for (double x = 0.0; x <= 5.0; x += 1) {
        actargs[0] = new Double(x); 
        Double ret = (Double)meth.invoke(null, actargs);
        double result = ret.doubleValue();
        System.out.println("  " + x + " -> " + result);
      }
    } catch (Exception e) {
      System.err.println(e.toString());
    }
  }

  public static void main(String[] args)
  {
    printTable("times2");
    printTable("java.lang.Math.exp");
    printTable("sqr");
    printTable("java.lang.Math.sqrt");
  }
}