/* DialogBeispiel.java */

import java.awt.*;
import java.awt.event.*;

class MyDialog
extends Dialog
implements ActionListener
{
  public MyDialog(Frame parent)
  {
    super(parent,"MyDialog",true);
    Point parloc = parent.getLocation();
    setBounds(parloc.x + 30, parloc.y + 30,400,300);
    setBackground(Color.lightGray);
    setLayout(new BorderLayout());
    //Panel
    Panel panel = new Panel();
    customizeLayout(panel);
    add(panel, BorderLayout.CENTER);
    //Ende-Button
    Button button = new Button("Ende");
    button.addActionListener(this);
    add(button, BorderLayout.SOUTH);
    //Window-Listener
    addWindowListener(
      new WindowAdapter() {
        public void windowClosing(WindowEvent event)
        {
          endDialog();
        }
      }
    );
    pack();
  }

  private void customizeLayout(Panel panel)
  {
    //Beispielcode hier
  }

  public void actionPerformed(ActionEvent event)
  {
    if (event.getActionCommand().equals("Ende")) {
      endDialog();
    }
  }

  void endDialog()
  {
    setVisible(false);
    dispose();
    ((Window)getParent()).toFront();
    getParent().requestFocus();
  }
}

public class DialogBeispiel
extends Frame
implements ActionListener
{
  public static void main(String[] args)
  {
    DialogBeispiel wnd = new DialogBeispiel();
    wnd.setSize(300,200);
    wnd.setVisible(true);
  }

  public DialogBeispiel()
  {
    super("Beispiel Dialogelemente");
    setBackground(Color.lightGray);
    setLayout(new FlowLayout());
    //Dialog-Button
    Button button = new Button("Dialog");
    button.addActionListener(this);
    add(button);
    //Ende-Button
    button = new Button("Ende");
    button.addActionListener(this);
    add(button);
    //Window-Listener
    addWindowListener(new WindowClosingAdapter(true));
  }

  public void actionPerformed(ActionEvent event)
  {
    String cmd = event.getActionCommand();
    if (cmd.equals("Dialog")) {
      MyDialog dlg = new MyDialog(this);
      dlg.setVisible(true);
    } else if (cmd.equals("Ende")) {
      setVisible(false);
      dispose();
      System.exit(0);
    }
  }
}