/* ColoredTableCellRenderer.java */

import java.awt.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.table.*;

public class ColoredTableCellRenderer
implements TableCellRenderer
{
  private Color lightBlue = new Color(160, 160, 255);
  private Color darkBlue  = new Color( 64,  64, 128);

  public Component getTableCellRendererComponent(
    JTable table,
    Object value,
    boolean isSelected,
    boolean hasFocus,
    int row,
    int column
  )
  {
    //Label erzeugen
    JLabel label = new JLabel((String)value);
    label.setOpaque(true);
    Border b = BorderFactory.createEmptyBorder(1, 1, 1, 1);
    label.setBorder(b);
    label.setFont(table.getFont());
    label.setForeground(table.getForeground());
    label.setBackground(table.getBackground());
    if (hasFocus) { 
      label.setBackground(darkBlue);
      label.setForeground(Color.white);
    } else if (isSelected) {
      label.setBackground(lightBlue);
    } else {
      //Angezeigte Spalte in Modellspalte umwandeln
      column = table.convertColumnIndexToModel(column); 
      if (column == 1) {
        int numpages = Integer.parseInt((String)value);
        if (numpages >= 250) {
          label.setBackground(Color.red);
        } else if (numpages >= 200) {
          label.setBackground(Color.orange);
        } else {
          label.setBackground(Color.yellow);
        }
      }
    }
    return label;
  }
}