/* CancelButton.java */

import java.awt.event.*;
import javax.swing.*;

public class CancelButton
extends JButton
{
  public CancelButton(String title)
  {
    super(title);
    ActionListener al = new ActionListener()
    {
      public void actionPerformed(ActionEvent event)
      {
        String cmd = event.getActionCommand();
        if (cmd.equals("PressedESCAPE")) {
          doClick();
        }
      }
    };
    registerKeyboardAction(
      al,
      "PressedESCAPE",
      KeyStroke.getKeyStroke(KeyEvent.VK_ESCAPE, 0),
      JButton.WHEN_IN_FOCUSED_WINDOW
    );
  }
}