/* ButtonPanel.java */

import java.awt.*;
import java.awt.event.*;
import java.beans.*;
import java.io.*;

public class ButtonPanel
extends Panel
implements Serializable, ItemListener
{
  //---Instanzvariablen------------------------------------
  protected CheckboxGroup cbg;
  protected Checkbox[]    cb;
  transient protected PropertyChangeSupport pcs;

  //---Methoden--------------------------------------------
  public ButtonPanel()
  {
    cbg = new CheckboxGroup();
    cb = new Checkbox[0];
    initTransientState();
  }

  //---Anzahl der RadioButtons-----------------------------
  public void setButtonCnt(int cnt)
  {
    if (cnt != cb.length) {
      int oldvalue = cb.length;
      //Bisherige Buttons entfernen
      if (cb.length > 0) {
        removeAll();
      }
      cb = new Checkbox[cnt];
      setLayout(new GridLayout(cnt, 1));
      for (int i = 0; i < cnt; ++i) {
        cb[i] = new Checkbox(
          "RadioButton " + i,
          cbg,
          (i == 0 ? true : false)
        );
        cb[i].addItemListener(this); 
        add(cb[i]);
      }
      //PropertyChangeEvents senden
      pcs.firePropertyChange("buttonCnt", oldvalue, cnt);
      if (cnt > 0) {
        setSelected(0);
      }
      //Neu layouten 
      setSize(getPreferredSize());
      invalidate();
      doLayout();
      Container owner = getParent();
      if (owner != null) {
        owner.invalidate();
        owner.doLayout();
      }
    }
  }

  public int getButtonCnt()
  {
    return cb.length;
  }

  //---Beschriftung der Buttons----------------------------
  public void setLabel(int index, String label)
  {
    if (index >= 0 && index < cb.length) {
      cb[index].setLabel(label);
    }
  }

  public String getLabel(int index)
  {
    String ret = "***invalid index***";
    if (index >= 0 && index < cb.length) {
      ret = cb[index].getLabel();
    }
    return ret;
  }

  //---Selektiertes Element--------------------------------
  public void setSelected(int index)
  {
    if (index >= 0 && index < cb.length) {
      int oldvalue = getSelected();
      cb[index].setState(true);
      pcs.firePropertyChange("selected", oldvalue, index);
    }
  }

  public int getSelected()
  {
    int ret = -1;
    for (int i = 0; i < cb.length; ++i) {
      if (cb[i].getState()) {
        ret = i;
        break;
      }
    }
    return ret;
  }

  //---Verwaltung der PropertyChangeListener---
  public void addPropertyChangeListener(
    PropertyChangeListener l
  )
  {
    pcs.addPropertyChangeListener(l);
  }

  public void removePropertyChangeListener(
    PropertyChangeListener l
  )
  {
    pcs.removePropertyChangeListener(l);
  }

  //---Reaktion auf Zustandsnderungen---------------------
  public void itemStateChanged(ItemEvent event)
  {
    Checkbox changedcb = (Checkbox) event.getItemSelectable();
    if (changedcb.getState()) {
      for (int i = 0; i < cb.length; ++i) {
        if (cb[i] == changedcb) {
          pcs.firePropertyChange("selected", -1, i);
          break;
        }
      }
    }
  }

  //---Private Methoden------------------------------------
  /**
   * Initialisierung der nicht-persistenten Instanzvariablen.
   */
  private void initTransientState()
  {
    pcs = new PropertyChangeSupport(this);
  }

  /**
   * Wird berlagert, um nach dem Deserialisieren den transienten
   * Zustand zu initialisieren.
   */
  private void readObject(ObjectInputStream stream)
  throws IOException, ClassNotFoundException
  {
    stream.defaultReadObject();
    initTransientState();
  }
}