/* BinTreeNode.java */

class BinTreeNode
implements Cloneable
{
  String      name;
  BinTreeNode leftChild;
  BinTreeNode rightChild;

  public BinTreeNode(String name)
  {
    this.name       = name;
    this.leftChild  = null;
    this.rightChild = null;
  }

  public Object clone()
  {
    try {
      BinTreeNode newNode = (BinTreeNode)super.clone();
      if (this.leftChild != null) {
        newNode.leftChild = (BinTreeNode)this.leftChild.clone();
      }
      if (this.rightChild != null) {
        newNode.rightChild = (BinTreeNode)this.rightChild.clone();
      }
      return newNode;
    } catch (CloneNotSupportedException e) {
      //Kann eigentlich nicht auftreten...
      throw new InternalError();
    }
  }
}