/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import oracle.jdbc.dbaccess.DBError;
import oracle.jdbc.driver.BaseResultSet;
import oracle.jdbc.driver.OracleConnection;
import oracle.jdbc.driver.OracleResultSetMetaData;
import oracle.jdbc.driver.OracleStatement;
import oracle.sql.ARRAY;
import oracle.sql.BFILE;
import oracle.sql.BLOB;
import oracle.sql.CHAR;
import oracle.sql.CLOB;
import oracle.sql.CustomDatum;
import oracle.sql.CustomDatumFactory;
import oracle.sql.DATE;
import oracle.sql.Datum;
import oracle.sql.INTERVALYM;
import oracle.sql.NUMBER;
import oracle.sql.OPAQUE;
import oracle.sql.ORAData;
import oracle.sql.ORADataFactory;
import oracle.sql.RAW;
import oracle.sql.REF;
import oracle.sql.ROWID;
import oracle.sql.STRUCT;
import oracle.sql.TIMESTAMP;
import oracle.sql.TIMESTAMPLTZ;
import oracle.sql.TIMESTAMPTZ;

public class OracleResultSetImpl
extends BaseResultSet {
    OracleConnection connection;
    OracleStatement statement;
    boolean closed;
    boolean explicitly_closed;
    private boolean m_emptyRset;

    OracleResultSetImpl(OracleConnection oracleConnection, OracleStatement oracleStatement) throws SQLException {
        this.connection = oracleConnection;
        this.statement = oracleStatement;
        this.close_statement_on_close = false;
        this.closed = false;
        this.explicitly_closed = false;
        this.m_emptyRset = false;
    }

    public synchronized void close() throws SQLException {
        this.internal_close();
        if (this.close_statement_on_close) {
            try {
                this.statement.close();
            }
            catch (SQLException sQLException) {}
        }
        this.explicitly_closed = true;
    }

    public synchronized int findColumn(String string) throws SQLException {
        return this.statement.get_column_index(string);
    }

    public synchronized ARRAY getARRAY(int n) throws SQLException {
        return this.statement.getARRAYValue(true, n);
    }

    public synchronized Array getArray(int n) throws SQLException {
        return this.getARRAY(n);
    }

    public synchronized InputStream getAsciiStream(int n) throws SQLException {
        return this.statement.getAsciiStreamValue(true, n);
    }

    public synchronized BFILE getBFILE(int n) throws SQLException {
        return this.statement.getBFILEValue(true, n);
    }

    public synchronized BLOB getBLOB(int n) throws SQLException {
        return this.statement.getBLOBValue(true, n);
    }

    public synchronized BFILE getBfile(int n) throws SQLException {
        return this.getBFILE(n);
    }

    public BigDecimal getBigDecimal(int n) throws SQLException {
        return this.statement.getBigDecimalValue(true, n, 0);
    }

    public synchronized BigDecimal getBigDecimal(int n, int n2) throws SQLException {
        return this.statement.getBigDecimalValue(true, n, n2);
    }

    public synchronized InputStream getBinaryStream(int n) throws SQLException {
        return this.statement.getBinaryStreamValue(true, n);
    }

    public synchronized Blob getBlob(int n) throws SQLException {
        return this.getBLOB(n);
    }

    public synchronized boolean getBoolean(int n) throws SQLException {
        return this.statement.getBooleanValue(true, n);
    }

    public synchronized byte getByte(int n) throws SQLException {
        return this.statement.getByteValue(true, n);
    }

    public synchronized byte[] getBytes(int n) throws SQLException {
        return this.statement.getBytesValue(true, n);
    }

    public synchronized CHAR getCHAR(int n) throws SQLException {
        return this.statement.getCHARValue(true, n);
    }

    public synchronized CLOB getCLOB(int n) throws SQLException {
        return this.statement.getCLOBValue(true, n);
    }

    public synchronized Reader getCharacterStream(int n) throws SQLException {
        return this.statement.getCharacterStreamValue(true, n);
    }

    public synchronized Clob getClob(int n) throws SQLException {
        return this.getCLOB(n);
    }

    public synchronized ResultSet getCursor(int n) throws SQLException {
        return this.statement.getCursorValue(true, n);
    }

    public synchronized CustomDatum getCustomDatum(int n, CustomDatumFactory customDatumFactory) throws SQLException {
        return this.statement.getCustomDatumValue(true, n, customDatumFactory);
    }

    public synchronized DATE getDATE(int n) throws SQLException {
        return this.statement.getDATEValue(true, n);
    }

    public synchronized Date getDate(int n) throws SQLException {
        return this.statement.getDateValue(true, n);
    }

    public Date getDate(int n, Calendar calendar) throws SQLException {
        return this.statement.getDateValue(true, n, calendar);
    }

    public synchronized double getDouble(int n) throws SQLException {
        return this.statement.getDoubleValue(true, n);
    }

    public int getFetchSize() throws SQLException {
        return this.statement.getPrefetchInternal(false);
    }

    public synchronized float getFloat(int n) throws SQLException {
        return this.statement.getFloatValue(true, n);
    }

    public INTERVALYM getINTERVALYM(int n) throws SQLException {
        return this.statement.getINTERVALYMValue(true, n);
    }

    public synchronized int getInt(int n) throws SQLException {
        return this.statement.getIntValue(true, n);
    }

    public synchronized long getLong(int n) throws SQLException {
        return this.statement.getLongValue(true, n);
    }

    public synchronized ResultSetMetaData getMetaData() throws SQLException {
        if (this.explicitly_closed) {
            DBError.check_error(10, "getMetaData");
        }
        if (this.statement.closed) {
            DBError.check_error(9, "getMetaData");
        }
        return new OracleResultSetMetaData(this.connection, this.statement);
    }

    public synchronized NUMBER getNUMBER(int n) throws SQLException {
        return this.statement.getNUMBERValue(true, n);
    }

    public synchronized OPAQUE getOPAQUE(int n) throws SQLException {
        return this.statement.getOPAQUEValue(true, n);
    }

    public synchronized ORAData getORAData(int n, ORADataFactory oRADataFactory) throws SQLException {
        return this.statement.getORADataValue(true, n, oRADataFactory);
    }

    public synchronized Object getObject(int n) throws SQLException {
        return this.statement.getObjectValue(true, n);
    }

    public synchronized Object getObject(int n, Map map) throws SQLException {
        return this.statement.getObjectValue(true, n, map);
    }

    public synchronized Datum getOracleObject(int n) throws SQLException {
        return this.statement.getOracleObjectValue(true, n);
    }

    public synchronized RAW getRAW(int n) throws SQLException {
        return this.statement.getRAWValue(true, n);
    }

    public synchronized REF getREF(int n) throws SQLException {
        return this.statement.getREFValue(true, n);
    }

    public synchronized ROWID getROWID(int n) throws SQLException {
        return this.statement.getROWIDValue(true, n);
    }

    public synchronized Ref getRef(int n) throws SQLException {
        return this.getREF(n);
    }

    public int getRow() throws SQLException {
        return this.statement.total_rows_visited;
    }

    public synchronized STRUCT getSTRUCT(int n) throws SQLException {
        return this.statement.getSTRUCTValue(true, n);
    }

    public synchronized short getShort(int n) throws SQLException {
        return this.statement.getShortValue(true, n);
    }

    public synchronized Statement getStatement() throws SQLException {
        return this.statement;
    }

    public synchronized String getString(int n) throws SQLException {
        return this.statement.getStringValue(true, n);
    }

    public TIMESTAMP getTIMESTAMP(int n) throws SQLException {
        return this.statement.getTIMESTAMPValue(true, n);
    }

    public TIMESTAMPLTZ getTIMESTAMPLTZ(int n) throws SQLException {
        return this.statement.getTIMESTAMPLTZValue(true, n);
    }

    public TIMESTAMPTZ getTIMESTAMPTZ(int n) throws SQLException {
        return this.statement.getTIMESTAMPTZValue(true, n);
    }

    public synchronized Time getTime(int n) throws SQLException {
        return this.statement.getTimeValue(true, n);
    }

    public Time getTime(int n, Calendar calendar) throws SQLException {
        return this.statement.getTimeValue(true, n, calendar);
    }

    public synchronized Timestamp getTimestamp(int n) throws SQLException {
        return this.statement.getTimestampValue(true, n);
    }

    public Timestamp getTimestamp(int n, Calendar calendar) throws SQLException {
        return this.statement.getTimestampValue(true, n, calendar);
    }

    public synchronized InputStream getUnicodeStream(int n) throws SQLException {
        return this.statement.getUnicodeStreamValue(true, n);
    }

    int getValidRows() {
        return this.statement.valid_rows;
    }

    void internal_close() throws SQLException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        if (this.statement.got_last_batch && this.statement.valid_rows == 0) {
            this.m_emptyRset = true;
        }
        try {
            this.statement.connection.needLine();
            this.statement.connection.db_access.closeQuery(this.statement.dbstmt);
        }
        catch (IOException iOException) {
            DBError.throwSqlException(iOException);
        }
        catch (SQLException sQLException) {}
        this.statement.end_of_result_set();
    }

    public boolean isAfterLast() throws SQLException {
        return !this.isEmptyResultSet() && this.closed;
    }

    public boolean isBeforeFirst() throws SQLException {
        return !this.isEmptyResultSet() && this.statement.current_row == -1 && !this.closed;
    }

    boolean isEmptyResultSet() {
        return this.m_emptyRset || !this.m_emptyRset && this.statement.got_last_batch && this.statement.valid_rows == 0;
    }

    public boolean isFirst() throws SQLException {
        return this.getRow() == 1;
    }

    public boolean isLast() throws SQLException {
        DBError.throwSqlException(75, "isLast");
        return false;
    }

    public synchronized boolean next() throws SQLException {
        if (this.explicitly_closed) {
            DBError.check_error(10, "next");
        }
        if (this.statement.connection == null || this.statement.connection.closed) {
            DBError.check_error(8, "next");
        }
        if (this.statement.closed) {
            DBError.check_error(9, "next");
        }
        if (this.closed) {
            return false;
        }
        ++this.statement.current_row;
        ++this.statement.total_rows_visited;
        if (this.statement.max_rows != 0 && this.statement.total_rows_visited > this.statement.max_rows) {
            this.internal_close();
            return false;
        }
        if (this.statement.current_row >= this.statement.valid_rows) {
            try {
                if (this.statement.got_last_batch) {
                    this.internal_close();
                    return false;
                }
                this.statement.check_row_prefetch_changed();
                this.prepare_for_new_row();
                this.statement.connection.needLine();
                this.statement.valid_rows = this.connection.db_access.fetch(this.statement.dbstmt, this.statement.defines, this.statement.row_prefetch);
                this.statement.fetchedFirstColumns();
                if (this.statement.valid_rows == 0) {
                    this.internal_close();
                    return false;
                }
                this.statement.current_row = 0;
                this.statement.checkValidRowsStatus();
                return true;
            }
            catch (IOException iOException) {
                DBError.check_error(iOException);
            }
        }
        return true;
    }

    void prepare_for_new_row() throws SQLException {
        if (this.statement.streams != null) {
            try {
                this.statement.streams.close();
            }
            catch (IOException iOException) {
                DBError.check_error(iOException);
            }
        }
        this.clearWarnings();
    }

    public void setFetchSize(int n) throws SQLException {
        this.statement.setPrefetchInternal(n, false, false);
    }

    public synchronized boolean wasNull() throws SQLException {
        return this.statement.wasNullValue();
    }
}

