#!/bin/bash
# Script for automatic generation of eule font
# Version 0.1, 2003/03/05
#
# ----------------------------------------------------------

function prepare()
{
    echo 'Delete old logfile'
    rm -f $LOGFILE

    echo 'Generation started at '`date`
    echo 'Generation started at '`date` >> $LOGFILE

    # test mftrace version
    if ! mftrace --version >/dev/null 2>/dev/null
    then
	echo 'mftrace not available. Aborting.' >&2
	echo 'mftrace not available. Aborting.' >> $LOGFILE
	exit 1
    fi
    V1=`mftrace --version | sed s/'.* \([0-9]\)*\.\([0-9]*\)\.\([0-9]*\)'/'\1'/`
    V2=`mftrace --version | sed s/'.* \([0-9]\)*\.\([0-9]*\)\.\([0-9]*\)'/'\2'/`
    V3=`mftrace --version | sed s/'.* \([0-9]\)*\.\([0-9]*\)\.\([0-9]*\)'/'\3'/`
    if (( $V1<1 ))
    then
	echo "mftrace 1.0.12 or newer needed. Installed is `mftrace --version`." >&2
	echo "mftrace 1.0.12 or newer needed. Installed is `mftrace --version`." >> $LOGFILE
	exit 1
    fi
    if (( $V1==1 && $V2<0 ))
    then
	echo "mftrace 1.0.12 or newer needed. Installed is `mftrace --version`." >&2
	echo "mftrace 1.0.12 or newer needed. Installed is `mftrace --version`." >> $LOGFILE
	exit 1
    fi
    if (( $V1==1 && $V2==0 && $V3<12 ))
    then
	echo "mftrace 1.0.12 or newer needed. Installed is `mftrace --version`." >&2
	echo "mftrace 1.0.12 or newer needed. Installed is `mftrace --version`." >> $LOGFILE
	exit 1
    fi

    echo 'Prepare directories for generation'

    echo 'Create directory work if not already present' >> $LOGFILE
    test -d work || mkdir work

    echo -n 'Create or clean directories:' >> $LOGFILE
    for DIR in pfb pfa dvips afm
    do
	echo -n " $DIR" >> $LOGFILE
	if [ -d $DIR ]
	then
	    rm -rf $DIR
	fi
	mkdir $DIR
    done
    echo '' >> $LOGFILE

    echo 'Enter directory work/' >> $LOGFILE
    cd work
    echo 'Clean the directory' >> $LOGFILE
    rm -f *

# Generation of symbolic links seems not to be necessary since mftrace
# searches the TeX path. I'm not sure if ./xbbold.mf is found.
# 
#    echo 'Generate symbolic links to all files in directory' >> $LOGFILE
#    echo "    "`kpsexpand '$TEXMFMAIN'`"/fonts/source/public/cmbright/" >> $LOGFILE
#    ln -s `kpsexpand '$TEXMFMAIN'`/fonts/source/public/cmbright/* .
}

# ----------------------------------------------------------

# $1   font name
# $2   encoding
# $3   FullName
# $4   Weight
# $5   ItalicAngle
# $6   isFixedPitch
# $7   UniqueID
#
# Most work is done by mftrace and pfaedit, but some things can't:
# - Set the UniqueID: pfaedit cannot set it in the Private dictionary
# - Set the Version: pfaedit seems not to do it
# - Set ItalicAngle: pfaedit does only integer values
# - Set isFixedPitch: pfaedit seems not to do it
function fontgen()
{
    INPUT=$1
    OUTPUT=$1
    FONTNAME=`echo $OUTPUT | sed -e y/abcdefghijklmnopqrstuvwxyz/ABCDEFGHIJKLMNOPQRSTUVWXYZ/`

    echo "Create font $FONTNAME"
    echo -e "\nCreate font $FONTNAME" >> $LOGFILE

    echo "Trace Metafont $INPUT.mf, create file $INPUT.pfa" >> $LOGFILE
    mftrace $TRACEOPT --encoding=$2.enc $INPUT >> $LOGFILE 2>&1

    echo "Create $OUTPUT.pfa and $OUTPUT.afm" >> $LOGFILE
    ../simplify-rename.pe $INPUT `kpsewhich $INPUT.tfm`  $OUTPUT \
	    "$FONTNAME" "$3" "$4" >> $LOGFILE 2>&1

    echo "Set UniqueID, Version, ItalicAngle, and FixedPitch in" >> $LOGFILE
    echo "    $OUTPUT.pfa and $OUTPUT.afm" >> $LOGFILE
    t1disasm tmp.pfa \
    | sed -e s_'\(%!PS-AdobeFont.*\) 001.001'_"\1 $VERSION"_ \
	-e s_'\(/version *(\)001.001'_"\1$VERSION"_ \
	-e s_'\(/UniqueID get\) [0-9]* \(eq\)'_"\1 $7 \2"_ \
	-e s_'\(/UniqueID\) [0-9]* \(def\)'_"\1 $7 \2"_ \
	-e s_'\(/ItalicAngle\).*\(def\)'_"\1 $5 \2"_ \
	-e s_'\(/isFixedPitch\).*\(def\)'_"\1 $6 \2"_ \
    | t1asm -a > $OUTPUT.pfa
    cat tmp.afm \
    | sed -e s_'^\(Version *\)001.001'_"\1$VERSION"_ \
	-e s_'^\(ItalicAngle\).*'_"\1 $5"_ \
	-e s_'^\(isFixedPitch\).*'_"\1 $6"_ \
    > $OUTPUT.afm

    echo "Convert $OUTPUT.pfa to $OUTPUT.pfb" >> $LOGFILE
    t1binary $OUTPUT.pfa $OUTPUT.pfb

    echo "Delete temporary files" >> $LOGFILE
    rm -f tmp.pfa tmp.afm
}

# ----------------------------------------------------------

function eule()
{
    fontgen eule tex256 "Eule" "Regular" 0 false 4164880
}

# ----------------------------------------------------------

function latexstuff()
{
    echo "Generate fontmap and dvips config file"

    echo "Generate fontmap eule.map" >> $LOGFILE
    # Generate fontmap
    echo 'eule EULE <eule.pfb' > eule.map

    echo "Generate dvips config file config.eule" >> $LOGFILE
    # Generate config file
    echo 'p +eule.map' > config.eule
}

# ----------------------------------------------------------

function postwork()
{
    echo "Move generated files to their directories"

    echo "Move pfb files to pfb/" >> $LOGFILE
    mv *.pfb ../pfb
    echo "Move pfa files to pfa/" >> $LOGFILE
    mv *.pfa ../pfa
    echo "Move afm files to afm/" >> $LOGFILE
    mv *.afm ../afm
    echo "Move eule.map and config.eule to dvips/" >> $LOGFILE
    mv eule.map config.eule ../dvips
    echo "Clean work/" >> $LOGFILE
    rm -f *
    echo "Leave directory work/" >> $LOGFILE
    cd ..
    echo "Delete directory work/" >> $LOGFILE
    rmdir work

    echo 'Generation ready at '`date`
    echo 'Generation ready at '`date` >> $LOGFILE
}


# ----------------------------------------------------------

function help()
{
    echo "eule v$VERSION, $PROGDATE" >&2
    echo '' >&2
    echo 'Script for automatic generation of the eule type1 fonts.' >&2
    echo 'It creates the subdirectories pfa, pfb, and dvips where it' >&2
    echo 'puts the generated files.' >&2
    echo 'For installation, see README resp. use install.sh.' >&2
    echo '' >&2
}

# ----------------------------------------------------------
# Main programme

LOGFILE=$PWD/eule.log
VERSION=0.1
PROGDATE=2003/03/05
# TRACEOPT="--simplify --afm"

if [ "$1" == "--help" -o "$1" == "-h" ]
then
    help
    exit 1
fi

prepare
eule
latexstuff
postwork

# ----------------------------------------------------------
