/*******************************************************************************
 * Copyright (c) 2000, 2003 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/

package org.eclipse.ui.internal.commands;

import org.eclipse.ui.commands.IContextBinding;

final class ContextBinding implements IContextBinding {

	private final static int HASH_FACTOR = 89;
	private final static int HASH_INITIAL =
		ContextBinding.class.getName().hashCode();

	private String activityId;

	private transient int hashCode;
	private transient boolean hashCodeComputed;

	ContextBinding(String activityId) {
		if (activityId == null)
			throw new NullPointerException();

		this.activityId = activityId;
	}

	public int compareTo(Object object) {
		ContextBinding castedObject = (ContextBinding) object;
		int compareTo = activityId.compareTo(castedObject.activityId);
		return compareTo;
	}

	public boolean equals(Object object) {
		if (!(object instanceof ContextBinding))
			return false;

		ContextBinding castedObject = (ContextBinding) object;
		boolean equals = true;
		equals &= activityId.equals(castedObject.activityId);
		return equals;
	}

	public String getContextId() {
		return activityId;
	}

	public int hashCode() {
		if (!hashCodeComputed) {
			hashCode = HASH_INITIAL;
			hashCode = hashCode * HASH_FACTOR + activityId.hashCode();
			hashCodeComputed = true;
		}

		return hashCode;
	}

	public String toString() {
		return activityId;
	}
}
