/*******************************************************************************
 * Copyright (c) 2000, 2003 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 ******************************************************************************/

package org.eclipse.ui.activities;

import java.util.regex.Pattern;

/**
 * An instance of this interface represents a binding between an activity and a
 * pattern.
 * <p>
 * This interface is not intended to be extended or implemented by clients.
 * </p>
 * <p>
 * <em>EXPERIMENTAL</em>
 * </p>
 * 
 * @since 3.0
 * @see IActivity
 */
public interface IActivityPatternBinding extends Comparable {

	/**
	 * Returns the identifier of the activity represented in this binding.
	 * 
	 * @return the identifier of the activity represented in this binding.
	 *         Guaranteed not to be <code>null</code>.
	 */
	String getActivityId();

	/**
	 * Returns the pattern represented in this binding.
	 * 
	 * @return the pattern. Guaranteed not to be <code>null</code>.
	 */
	Pattern getPattern();
}
