/*******************************************************************************
 * Copyright (c) 2000, 2003 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.help.ui.internal.ide;
import org.eclipse.core.runtime.*;
import org.eclipse.help.internal.base.*;
import org.eclipse.help.ui.internal.util.*;
import org.eclipse.help.ui.internal.workingset.*;
import org.eclipse.ui.*;
import org.eclipse.ui.plugin.*;

/**
  * This class is a Help IDE plugin.
  */
public class HelpIdePlugin extends AbstractUIPlugin {
	public final static String PLUGIN_ID = "org.eclipse.help.ide";
	// debug options
	public static boolean DEBUG = false;

	private static HelpIdePlugin plugin;
	private HelpWorkingSetSynchronizer workingSetListener;

	/** 
	 * Logs an Error message with an exception. Note that the message should already 
	 * be localized to proper locale.
	 * ie: Resources.getString() should already have been called
	 */
	public static synchronized void logError(String message, Throwable ex) {
		if (message == null)
			message = "";
		Status errorStatus =
			new Status(IStatus.ERROR, PLUGIN_ID, IStatus.OK, message, ex);
		HelpBasePlugin.getDefault().getLog().log(errorStatus);
	}
	/** 
	 * Logs a Warning message with an exception. Note that the message should already 
	 * be localized to proper local.
	 * ie: Resources.getString() should already have been called
	 */
	public static synchronized void logWarning(String message) {
		if (HelpBasePlugin.DEBUG) {
			if (message == null)
				message = "";
			Status warningStatus =
				new Status(
					IStatus.WARNING,
					PLUGIN_ID,
					IStatus.OK,
					message,
					null);
			HelpBasePlugin.getDefault().getLog().log(warningStatus);
		}
	}

	/**
	 * Constructor. It is called as part of plugin
	 * activation.
	 */
	public HelpIdePlugin(IPluginDescriptor descriptor) {
		super(descriptor);
		plugin = this;
	}
	/**
	 * Provides access to singleton
	 * @return HelpIDEPlugin
	 */
	public static HelpIdePlugin getDefault() {
		return plugin;
	}
	/**
	 * Shuts down this plug-in and discards all plug-in state.
	 * @exception CoreException if this method fails to shut down
	 *   this plug-in 
	 */
	public void shutdown() throws CoreException {

		if (BaseHelpSystem.getMode() == BaseHelpSystem.MODE_WORKBENCH) {
			PlatformUI
				.getWorkbench()
				.getWorkingSetManager()
				.removePropertyChangeListener(
				workingSetListener);
			BaseHelpSystem.getWorkingSetManager().removePropertyChangeListener(
				workingSetListener);
		}
		super.shutdown();
	}
	/**
	 * Called by Platform after loading the plugin
	 */
	public void startup() {
		// Setup debugging options
		DEBUG = isDebugging();
		if (DEBUG) {
		}

		BaseHelpSystem.setDefaultErrorUtil(new ErrorUtil());
		if (BaseHelpSystem.getMode() == BaseHelpSystem.MODE_WORKBENCH) {
			// register the working set listener to keep the ui and the help working sets in sych
			workingSetListener = new HelpWorkingSetSynchronizer();
			PlatformUI
				.getWorkbench()
				.getWorkingSetManager()
				.addPropertyChangeListener(
				workingSetListener);
			BaseHelpSystem.getWorkingSetManager().addPropertyChangeListener(
				workingSetListener);
		}
	}

	public HelpWorkingSetSynchronizer getWorkingSetSynchronizer() {
		return workingSetListener;
	}
}
