/*******************************************************************************
 * Copyright (c) 2000, 2003 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.pde.internal.ui.editor.manifest;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IProject;
import java.util.*;
import org.eclipse.pde.core.plugin.*;
import org.eclipse.pde.internal.core.ischema.*;
import org.eclipse.pde.internal.ui.*;
import org.eclipse.jface.action.*;
import org.eclipse.pde.internal.core.plugin.PluginElement;

public class NewElementAction extends Action {
	public static final String UNKNOWN_ELEMENT_TAG = "Generic";
	private ISchemaElement elementInfo;
	private Hashtable counters;
	private IPluginParent parent;
	private IProject project;

public NewElementAction(ISchemaElement elementInfo, IPluginParent parent) {
	this.counters= PDEPlugin.getDefault().getDefaultNameCounters();
	this.elementInfo = elementInfo;
	//this.project = project;
	this.parent = parent;
	setText(getElementName());
	setImageDescriptor(PDEPluginImages.DESC_GENERIC_XML_OBJ);
	IResource resource = parent.getModel().getUnderlyingResource();
	if (resource!=null) project = resource.getProject();
	setEnabled(parent.getModel().isEditable());
}
public String createDefaultClassName(ISchemaAttribute attInfo, int counter) {
	String tag = attInfo.getParent().getName();
	String projectName = project.getName();
	String packageName = projectName;
	String expectedType = attInfo.getBasedOn();
	String className = "";
	if (expectedType == null) {
		StringBuffer buf = new StringBuffer(tag);
		buf.setCharAt(0, Character.toUpperCase(tag.charAt(0)));
		className = buf.toString();
	} else {
		//package will be the same as the plugin ID
		// class name will be generated based on the required interface
		className = expectedType;
		int dotLoc = className.lastIndexOf('.');
		if (dotLoc != -1)
			className = className.substring(dotLoc + 1);
		if (className.charAt(0) == 'I')
			className = className.substring(1);
	}
	className += counter;
	return packageName + "." + className;
}
public String createDefaultName(ISchemaAttribute attInfo, int counter) {
	if (attInfo.getType().getName().equals("boolean"))
		return "true";
	
	String tag = attInfo.getParent().getName();
	return project.getName() + "." + tag + counter;
}
private String getCounterKey(ISchemaElement elementInfo) {
	return elementInfo.getSchema().getQualifiedPointId()+"."+elementInfo.getName();
}
private String getElementName() {
	return elementInfo!=null?elementInfo.getName() : UNKNOWN_ELEMENT_TAG;
}
private void initializeRequiredAttribute(
	IPluginElement element,
	ISchemaAttribute attInfo,
	int counter)
	throws CoreException {
	String value = null;
	if (attInfo.getKind() == ISchemaAttribute.JAVA)
		value = createDefaultClassName(attInfo, counter);
	else
		value = createDefaultName(attInfo, counter);

	element.setAttribute(attInfo.getName(), value);
}
private void initializeRequiredAttributes(IPluginElement element) throws CoreException {
	ISchemaElement elementInfo = ((PluginElement)element).getElementInfo();
	if (elementInfo==null) return;
	String counterKey = getCounterKey(elementInfo);
	Integer counter = (Integer)counters.get(counterKey);
	if (counter==null) {
		counter = new Integer(1);
	}
	else counter = new Integer(counter.intValue() + 1);
	counters.put(counterKey, counter);
	ISchemaAttribute [] attributes = elementInfo.getAttributes();
	for (int i=0; i<attributes.length; i++) {
		ISchemaAttribute attInfo = attributes[i];
		if (attInfo.getUse()!=ISchemaAttribute.REQUIRED) continue;
		initializeRequiredAttribute(element, attInfo, counter.intValue());
	}
}
public void run() {
	IPluginElement newElement =
		parent.getModel().getFactory().createElement(parent);
	try {
		newElement.setName(getElementName());
		initializeRequiredAttributes(newElement);
		parent.add(newElement);
	} catch (CoreException e) {
		PDEPlugin.logException(e);
	}
}
}
