/*******************************************************************************
 * Copyright (c) 2003 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/

package org.eclipse.osgi.framework.eventmgr;



/**
 * The EventSource interface contains the method that is called by the
 * Event Manager to complete the event delivery to the event listener.
 */

public abstract interface EventSource
{
    /**
     * This method is the call back that is called once for each listener.
     * This method must cast the EventListener object to the appropriate listener
     * class for the event type and call the appropriate listener method.
     *
     * @param listener This listener must be cast to the appropriate listener
     * class for the events created by this source and the appropriate listener method
     * must then be called.
     * @param listenerObject This is the optional object that was passed to
     * ListenerList.addListener when the listener was added to the ListenerList.
     * @param eventAction This value was passed to the EventQueue object via one of its
     * dispatchEvent* method calls. It can provide information (such
     * as which listener method to call) so that this method
     * can complete the delivery of the event to the listener.
     * @param eventObject This object was passed to the EventQueue object via one of its
     * dispatchEvent* method calls. This object was created by the event source and
     * is passed to this method. It should contain all the necessary information (such
     * as what event object to pass) so that this method
     * can complete the delivery of the event to the listener.
     */
    public abstract void dispatchEvent(Object listener, Object listenerObject, int eventAction, Object eventObject);
}
