/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.texteditor.quickdiff;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.AnnotationModelEvent;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IAnnotationModelListener;
import org.eclipse.jface.text.source.IAnnotationModelListenerExtension;
import org.eclipse.jface.text.source.ILineDiffInfo;
import org.eclipse.jface.text.source.ILineDiffer;
import org.eclipse.jface.util.Assert;
import org.eclipse.ui.internal.texteditor.TextEditorPlugin;
import org.eclipse.ui.internal.texteditor.quickdiff.QuickDiffMessages;
import org.eclipse.ui.internal.texteditor.quickdiff.compare.rangedifferencer.DocLineComparator;
import org.eclipse.ui.internal.texteditor.quickdiff.compare.rangedifferencer.IRangeComparator;
import org.eclipse.ui.internal.texteditor.quickdiff.compare.rangedifferencer.RangeDifference;
import org.eclipse.ui.internal.texteditor.quickdiff.compare.rangedifferencer.RangeDifferencer;
import org.eclipse.ui.texteditor.quickdiff.IQuickDiffReferenceProvider;

public class DocumentLineDiffer
implements ILineDiffer,
IDocumentListener,
IAnnotationModel {
    IQuickDiffReferenceProvider fReferenceProvider;
    private boolean fIsSynchronized;
    private int fOpenConnections;
    private IDocument fLeftDocument;
    private IDocument fRightDocument;
    private boolean fUpdateNeeded;
    private List fAnnotationModelListeners = new ArrayList();
    private Job fInitializationJob;
    private List fStoredEvents = new ArrayList();
    private List fDifferences = new ArrayList();
    private int fFirstLine;
    private int fNLines;
    private RangeDifference fLastDifference;

    public ILineDiffInfo getLineInfo(int line) {
        if (this.fLastDifference != null && this.fLastDifference.rightStart() <= line && this.fLastDifference.rightEnd() > line) {
            return new DiffRegion(this.fLastDifference, line - this.fLastDifference.rightStart());
        }
        this.fLastDifference = this.getRangeDifferenceForRightLine(line);
        if (this.fLastDifference != null) {
            return new DiffRegion(this.fLastDifference, line - this.fLastDifference.rightStart());
        }
        return null;
    }

    public synchronized void revertLine(int line) throws BadLocationException {
        String replacement;
        if (!this.isInitialized()) {
            throw new BadLocationException(QuickDiffMessages.getString("quickdiff.nonsynchronized"));
        }
        DiffRegion region = (DiffRegion)this.getLineInfo(line);
        if (region == null || this.fRightDocument == null || this.fLeftDocument == null) {
            return;
        }
        RangeDifference diff = region.fDifference;
        int rOffset = this.fRightDocument.getLineOffset(line);
        int rLength = this.fRightDocument.getLineLength(line);
        int leftLine = diff.leftStart() + region.fOffset;
        if (leftLine >= diff.leftEnd()) {
            replacement = new String();
        } else {
            int lOffset = this.fLeftDocument.getLineOffset(leftLine);
            int lLength = this.fLeftDocument.getLineLength(leftLine);
            replacement = this.fLeftDocument.get(lOffset, lLength);
        }
        this.fRightDocument.replace(rOffset, rLength, replacement);
    }

    public synchronized void revertBlock(int line) throws BadLocationException {
        if (!this.isInitialized()) {
            throw new BadLocationException(QuickDiffMessages.getString("quickdiff.nonsynchronized"));
        }
        DiffRegion region = (DiffRegion)this.getLineInfo(line);
        if (region == null || this.fRightDocument == null || this.fLeftDocument == null) {
            return;
        }
        RangeDifference diff = region.fDifference;
        int rOffset = this.fRightDocument.getLineOffset(diff.rightStart());
        int rLength = this.fRightDocument.getLineOffset(diff.rightEnd() - 1) + this.fRightDocument.getLineLength(diff.rightEnd() - 1) - rOffset;
        int lOffset = this.fLeftDocument.getLineOffset(diff.leftStart());
        int lLength = this.fLeftDocument.getLineOffset(diff.leftEnd() - 1) + this.fLeftDocument.getLineLength(diff.leftEnd() - 1) - lOffset;
        this.fRightDocument.replace(rOffset, rLength, this.fLeftDocument.get(lOffset, lLength));
    }

    public synchronized void revertSelection(int line, int nLines) throws BadLocationException {
        if (!this.isInitialized()) {
            throw new BadLocationException(QuickDiffMessages.getString("quickdiff.nonsynchronized"));
        }
        int rOffset = -1;
        int rLength = -1;
        int lOffset = -1;
        int lLength = -1;
        RangeDifference diff = null;
        Iterator it = this.fDifferences.iterator();
        while (it.hasNext()) {
            diff = (RangeDifference)it.next();
            if (line >= diff.rightEnd()) continue;
            rOffset = this.fRightDocument.getLineOffset(line);
            int leftLine = Math.min(diff.leftStart() + line - diff.rightStart(), diff.leftEnd() - 1);
            lOffset = this.fLeftDocument.getLineOffset(leftLine);
            break;
        }
        if (rOffset == -1 || lOffset == -1) {
            return;
        }
        int to = line + nLines - 1;
        while (it.hasNext()) {
            diff = (RangeDifference)it.next();
            if (to >= diff.rightEnd()) continue;
            int rEndOffset = this.fRightDocument.getLineOffset(to) + this.fRightDocument.getLineLength(to);
            rLength = rEndOffset - rOffset;
            int leftLine = Math.min(diff.leftStart() + to - diff.rightStart(), diff.leftEnd() - 1);
            int lEndOffset = this.fLeftDocument.getLineOffset(leftLine) + this.fLeftDocument.getLineLength(leftLine);
            lLength = lEndOffset - lOffset;
            break;
        }
        if (rLength == -1 || lLength == -1) {
            return;
        }
        this.fRightDocument.replace(rOffset, rLength, this.fLeftDocument.get(lOffset, lLength));
    }

    public synchronized int restoreAfterLine(int line) throws BadLocationException {
        if (!this.isInitialized()) {
            throw new BadLocationException(QuickDiffMessages.getString("quickdiff.nonsynchronized"));
        }
        DiffRegion region = (DiffRegion)this.getLineInfo(line);
        if (region == null || this.fRightDocument == null || this.fLeftDocument == null) {
            return 0;
        }
        if (region.getRemovedLinesBelow() < 1) {
            return 0;
        }
        RangeDifference diff = null;
        Iterator it = this.fDifferences.iterator();
        while (it.hasNext()) {
            diff = (RangeDifference)it.next();
            if (line < diff.rightStart() || line >= diff.rightEnd()) continue;
            if (diff.kind() != 0 || !it.hasNext()) break;
            diff = (RangeDifference)it.next();
            break;
        }
        if (diff == null) {
            return 0;
        }
        int rOffset = this.fRightDocument.getLineOffset(diff.rightEnd());
        int rLength = 0;
        int leftLine = diff.leftStart() + diff.rightLength();
        int lOffset = this.fLeftDocument.getLineOffset(leftLine);
        int lLength = this.fLeftDocument.getLineOffset(diff.leftEnd() - 1) + this.fLeftDocument.getLineLength(diff.leftEnd() - 1) - lOffset;
        this.fRightDocument.replace(rOffset, rLength, this.fLeftDocument.get(lOffset, lLength));
        return diff.leftLength() - diff.rightLength();
    }

    private boolean isInitialized() {
        return this.fIsSynchronized;
    }

    public synchronized boolean isSynchronized() {
        return this.fIsSynchronized;
    }

    public void setReferenceProvider(IQuickDiffReferenceProvider provider) {
        Assert.isNotNull((Object)provider);
        if (provider != this.fReferenceProvider) {
            if (this.fReferenceProvider != null) {
                this.fReferenceProvider.dispose();
            }
            this.fReferenceProvider = provider;
            this.initialize();
        }
    }

    public IQuickDiffReferenceProvider getReferenceProvider() {
        return this.fReferenceProvider;
    }

    synchronized void initialize() {
        Job oldJob;
        this.fIsSynchronized = false;
        if (this.fRightDocument == null) {
            return;
        }
        this.fRightDocument.removeDocumentListener((IDocumentListener)this);
        if (this.fLeftDocument != null) {
            this.fLeftDocument.removeDocumentListener((IDocumentListener)this);
            this.fLeftDocument = null;
        }
        if ((oldJob = this.fInitializationJob) != null) {
            if (oldJob.getState() == 2) {
                return;
            }
            oldJob.cancel();
        }
        this.fInitializationJob = new Job(QuickDiffMessages.getString("quickdiff.initialize")){

            public IStatus run(IProgressMonitor monitor) {
                ArrayList storedEvents;
                IDocument left;
                if (oldJob != null) {
                    try {
                        oldJob.join();
                    }
                    catch (InterruptedException interruptedException) {
                        Assert.isTrue((boolean)false);
                    }
                }
                IQuickDiffReferenceProvider provider = DocumentLineDiffer.this.fReferenceProvider;
                try {
                    left = provider == null ? null : provider.getReference(monitor);
                }
                catch (CoreException e) {
                    DocumentLineDiffer documentLineDiffer = DocumentLineDiffer.this;
                    synchronized (documentLineDiffer) {
                        if (this.isCanceled(monitor)) {
                            return Status.CANCEL_STATUS;
                        }
                        this.clearModel();
                        DocumentLineDiffer.this.fireModelChanged();
                        DocumentLineDiffer.this.notifyAll();
                        return e.getStatus();
                    }
                }
                catch (OperationCanceledException operationCanceledException) {
                    return Status.CANCEL_STATUS;
                }
                IDocument right = DocumentLineDiffer.this.fRightDocument;
                Document actual = null;
                Document reference = null;
                DocumentLineDiffer documentLineDiffer = DocumentLineDiffer.this;
                synchronized (documentLineDiffer) {
                    if (left == null || right == null) {
                        if (this.isCanceled(monitor)) {
                            return Status.CANCEL_STATUS;
                        }
                        this.clearModel();
                        DocumentLineDiffer.this.fireModelChanged();
                        DocumentLineDiffer.this.notifyAll();
                        return Status.OK_STATUS;
                    }
                    DocumentLineDiffer.this.fLeftDocument = left;
                }
                right.addDocumentListener((IDocumentListener)DocumentLineDiffer.this);
                left.addDocumentListener((IDocumentListener)DocumentLineDiffer.this);
                while (true) {
                    documentLineDiffer = DocumentLineDiffer.this;
                    synchronized (documentLineDiffer) {
                        if (this.isCanceled(monitor)) {
                            return Status.CANCEL_STATUS;
                        }
                        DocumentLineDiffer.this.fStoredEvents.clear();
                    }
                    reference = new Document(left.get());
                    actual = new Document(right.get());
                    documentLineDiffer = DocumentLineDiffer.this;
                    synchronized (documentLineDiffer) {
                        if (DocumentLineDiffer.this.fStoredEvents.size() == 0) {
                            break;
                        }
                    }
                }
                DocLineComparator ref = new DocLineComparator((IDocument)reference, null, false);
                DocLineComparator act = new DocLineComparator((IDocument)actual, null, false);
                List diffs = RangeDifferencer.findRanges(monitor, (IRangeComparator)ref, (IRangeComparator)act);
                DocumentLineDiffer documentLineDiffer2 = DocumentLineDiffer.this;
                synchronized (documentLineDiffer2) {
                    if (this.isCanceled(monitor)) {
                        return Status.CANCEL_STATUS;
                    }
                    DocumentLineDiffer.this.fDifferences = diffs;
                    storedEvents = new ArrayList(DocumentLineDiffer.this.fStoredEvents);
                    DocumentLineDiffer.this.fStoredEvents.clear();
                }
                try {
                    ListIterator iter = storedEvents.listIterator();
                    while (iter.hasNext()) {
                        DocumentEvent event = (DocumentEvent)iter.next();
                        DocumentLineDiffer.this.handleAboutToBeChanged(event);
                        DocumentLineDiffer.this.handleChanged(event);
                        DocumentLineDiffer documentLineDiffer3 = DocumentLineDiffer.this;
                        synchronized (documentLineDiffer3) {
                            if (this.isCanceled(monitor)) {
                                return Status.CANCEL_STATUS;
                            }
                            if (DocumentLineDiffer.this.fStoredEvents.size() > 0) {
                                left.removeDocumentListener((IDocumentListener)DocumentLineDiffer.this);
                                right.removeDocumentListener((IDocumentListener)DocumentLineDiffer.this);
                                this.clearModel();
                                DocumentLineDiffer.this.initialize();
                                return Status.CANCEL_STATUS;
                            }
                        }
                    }
                }
                catch (BadLocationException badLocationException) {
                    left.removeDocumentListener((IDocumentListener)DocumentLineDiffer.this);
                    right.removeDocumentListener((IDocumentListener)DocumentLineDiffer.this);
                    this.clearModel();
                    DocumentLineDiffer.this.initialize();
                    return Status.CANCEL_STATUS;
                }
                documentLineDiffer2 = DocumentLineDiffer.this;
                synchronized (documentLineDiffer2) {
                    DocumentLineDiffer.this.fInitializationJob = null;
                    DocumentLineDiffer.this.fIsSynchronized = true;
                    DocumentLineDiffer.this.fLastDifference = null;
                    DocumentLineDiffer.this.notifyAll();
                }
                DocumentLineDiffer.this.fireModelChanged();
                return Status.OK_STATUS;
            }

            private boolean isCanceled(IProgressMonitor monitor) {
                return DocumentLineDiffer.this.fInitializationJob != this || monitor != null && monitor.isCanceled();
            }

            private void clearModel() {
                DocumentLineDiffer.this.fLeftDocument = null;
                DocumentLineDiffer.this.fInitializationJob = null;
                DocumentLineDiffer.this.fStoredEvents.clear();
                DocumentLineDiffer.this.fLastDifference = null;
                DocumentLineDiffer.this.fDifferences.clear();
            }
        };
        this.fInitializationJob.setPriority(50);
        this.fInitializationJob.schedule();
    }

    public synchronized void documentAboutToBeChanged(DocumentEvent event) {
        if (!this.isInitialized() && this.fInitializationJob != null) {
            this.fStoredEvents.add(event);
            return;
        }
        try {
            this.handleAboutToBeChanged(event);
        }
        catch (BadLocationException e) {
            TextEditorPlugin.getDefault().getLog().log((IStatus)new Status(2, "org.eclipse.ui.workbench.texteditor", 0, "reinitializing quickdiff", (Throwable)e));
            this.initialize();
        }
    }

    void handleAboutToBeChanged(DocumentEvent event) throws BadLocationException {
        IDocument doc = event.getDocument();
        if (doc == null) {
            return;
        }
        this.fFirstLine = doc.getLineOfOffset(event.getOffset());
        this.fNLines = doc.getLineOfOffset(event.getOffset() + event.getLength()) - this.fFirstLine + 1;
    }

    public synchronized void documentChanged(DocumentEvent event) {
        if (!this.isInitialized()) {
            return;
        }
        if (event.getDocument() == this.fLeftDocument) {
            this.initialize();
            return;
        }
        try {
            this.handleChanged(event);
        }
        catch (BadLocationException e) {
            TextEditorPlugin.getDefault().getLog().log((IStatus)new Status(2, "org.eclipse.ui.workbench.texteditor", 0, "reinitializing quickdiff", (Throwable)e));
            this.initialize();
            return;
        }
        if (this.fUpdateNeeded) {
            this.fireModelChanged();
            this.fUpdateNeeded = false;
        }
    }

    void handleChanged(DocumentEvent event) throws BadLocationException {
        Object o;
        RangeDifference current;
        RangeDifference consistentAfter;
        RangeDifference consistentBefore;
        int repetitionField;
        int originalLine;
        String insertion;
        int added;
        IDocument left = this.fLeftDocument;
        IDocument right = this.fRightDocument;
        IDocument modified = event.getDocument();
        if (modified != left && modified != right) {
            Assert.isTrue((boolean)false);
        }
        int n = added = (insertion = event.getText()) == null ? 1 : modified.computeNumberOfLines(insertion) + 1;
        if (added > 50 || this.fNLines > 50) {
            this.initialize();
            return;
        }
        int size = Math.max(this.fNLines, added) + 1;
        int lineDelta = added - this.fNLines;
        int lastLine = this.fFirstLine + this.fNLines - 1;
        if (modified == left) {
            originalLine = this.getRightLine(lastLine + 1);
            repetitionField = this.searchForRepetitionField(size - 1, right, originalLine);
        } else {
            originalLine = this.getLeftLine(lastLine + 1);
            repetitionField = this.searchForRepetitionField(size - 1, left, originalLine);
        }
        lastLine += repetitionField;
        if (modified == left) {
            consistentBefore = this.findConsistentRangeBeforeLeft(this.fFirstLine, size);
            consistentAfter = this.findConsistentRangeAfterLeft(lastLine, size);
        } else {
            consistentBefore = this.findConsistentRangeBeforeRight(this.fFirstLine, size);
            consistentAfter = this.findConsistentRangeAfterRight(lastLine, size);
        }
        int shiftBefore = 0;
        if (consistentBefore.kind() == 0) {
            int unchanged = modified == left ? Math.min(this.fFirstLine, consistentBefore.leftEnd()) - consistentBefore.leftStart() : Math.min(this.fFirstLine, consistentBefore.rightEnd()) - consistentBefore.rightStart();
            shiftBefore = Math.max(0, unchanged - size);
        }
        int shiftAfter = 0;
        if (consistentAfter.kind() == 0) {
            int unchanged = modified == left ? consistentAfter.leftEnd() - Math.max(lastLine + 1, consistentAfter.leftStart()) : consistentAfter.rightEnd() - Math.max(lastLine + 1, consistentAfter.rightStart());
            shiftAfter = Math.max(0, unchanged - size);
        }
        int leftOffset = left.getLineOffset(consistentBefore.leftStart() + shiftBefore);
        int leftLine = Math.max(consistentAfter.leftEnd() - 1, 0);
        if (modified == left) {
            leftLine += lineDelta;
        }
        IRegion leftLastLine = left.getLineInformation(leftLine - shiftAfter);
        int leftEndOffset = leftLastLine.getOffset() + leftLastLine.getLength();
        Region leftRegion = new Region(leftOffset, leftEndOffset - leftOffset);
        DocLineComparator reference = new DocLineComparator(left, (IRegion)leftRegion, false);
        int rightOffset = right.getLineOffset(consistentBefore.rightStart() + shiftBefore);
        int rightLine = Math.max(consistentAfter.rightEnd() - 1, 0);
        if (modified == right) {
            rightLine += lineDelta;
        }
        IRegion rightLastLine = right.getLineInformation(rightLine - shiftAfter);
        int rightEndOffset = rightLastLine.getOffset() + rightLastLine.getLength();
        Region rightRegion = new Region(rightOffset, rightEndOffset - rightOffset);
        DocLineComparator change = new DocLineComparator(right, (IRegion)rightRegion, false);
        if (leftLine - shiftAfter - (consistentBefore.leftStart() + shiftBefore) > 50 || rightLine - shiftAfter - (consistentBefore.rightStart() + shiftBefore) > 50) {
            this.initialize();
            return;
        }
        List diffs = RangeDifferencer.findRanges(reference, change);
        if (diffs.size() == 0) {
            diffs.add(new RangeDifference(2, 0, 0, 0, 0));
        }
        int leftShift = consistentBefore.leftStart() + shiftBefore;
        int rightShift = consistentBefore.rightStart() + shiftBefore;
        Iterator it = diffs.iterator();
        while (it.hasNext()) {
            RangeDifference d = (RangeDifference)it.next();
            d.shiftLeft(leftShift);
            d.shiftRight(rightShift);
        }
        if (shiftBefore > 0) {
            RangeDifference first = (RangeDifference)diffs.get(0);
            if (first.kind() == 0) {
                first.extendStart(-shiftBefore);
            } else {
                diffs.add(0, new RangeDifference(0, first.rightStart() - shiftBefore, shiftBefore, first.leftStart() - shiftBefore, shiftBefore));
            }
        }
        RangeDifference last = (RangeDifference)diffs.get(diffs.size() - 1);
        if (shiftAfter > 0) {
            if (last.kind() == 0) {
                last.extendEnd(shiftAfter);
            } else {
                diffs.add(new RangeDifference(0, last.rightEnd(), shiftAfter, last.leftEnd(), shiftAfter));
            }
        }
        ListIterator it2 = this.fDifferences.listIterator();
        Iterator newIt = diffs.iterator();
        boolean changed = false;
        do {
            Assert.isTrue((boolean)it2.hasNext());
        } while ((current = (RangeDifference)it2.next()) != consistentBefore);
        Assert.isTrue((current == consistentBefore ? 1 : 0) != 0);
        while (current != consistentAfter) {
            if (newIt.hasNext()) {
                o = newIt.next();
                if (!current.equals(o)) {
                    changed = true;
                    it2.set(o);
                }
            } else {
                it2.remove();
                this.fUpdateNeeded = true;
            }
            Assert.isTrue((boolean)it2.hasNext());
            current = (RangeDifference)it2.next();
        }
        Assert.isTrue((current == consistentAfter ? 1 : 0) != 0);
        if (newIt.hasNext()) {
            o = newIt.next();
            if (!current.equals(o)) {
                changed = true;
                it2.set(o);
            }
        } else {
            it2.remove();
            this.fUpdateNeeded = true;
        }
        while (newIt.hasNext()) {
            it2.add(newIt.next());
            changed = true;
        }
        boolean init = true;
        while (it2.hasNext()) {
            current = (RangeDifference)it2.next();
            if (init) {
                init = false;
                leftShift = last.leftEnd() - current.leftStart();
                rightShift = last.rightEnd() - current.rightStart();
                if (leftShift == 0 && rightShift == 0) break;
                changed = true;
            }
            current.shiftLeft(leftShift);
            current.shiftRight(rightShift);
        }
        this.fUpdateNeeded = changed;
        this.fLastDifference = null;
    }

    private RangeDifference findConsistentRangeBeforeLeft(int line, int size) {
        RangeDifference found = null;
        ListIterator it = this.fDifferences.listIterator();
        while (it.hasNext()) {
            RangeDifference difference = (RangeDifference)it.next();
            if (found == null || difference.kind() == 0 && (difference.leftEnd() < line && difference.leftLength() >= size || difference.leftEnd() >= line && line - difference.leftStart() >= size)) {
                found = difference;
            }
            if (difference.leftEnd() >= line) break;
        }
        return found;
    }

    private RangeDifference findConsistentRangeAfterLeft(int line, int size) {
        RangeDifference found = null;
        ListIterator it = this.fDifferences.listIterator(this.fDifferences.size());
        while (it.hasPrevious()) {
            RangeDifference difference = (RangeDifference)it.previous();
            if (found == null || difference.kind() == 0 && (difference.leftStart() > line && difference.leftLength() >= size || difference.leftStart() <= line && difference.leftEnd() - line >= size)) {
                found = difference;
            }
            if (difference.leftStart() <= line) break;
        }
        return found;
    }

    private RangeDifference findConsistentRangeBeforeRight(int line, int size) {
        RangeDifference found = null;
        int unchanged = -1;
        ListIterator it = this.fDifferences.listIterator();
        while (it.hasNext()) {
            RangeDifference difference = (RangeDifference)it.next();
            if (found == null) {
                found = difference;
            } else if (difference.kind() == 0 && (unchanged = Math.min(line, difference.rightEnd()) - difference.rightStart()) >= size) {
                found = difference;
            }
            if (difference.rightEnd() >= line) break;
        }
        return found;
    }

    private RangeDifference findConsistentRangeAfterRight(int line, int size) {
        RangeDifference found = null;
        int unchanged = -1;
        ListIterator it = this.fDifferences.listIterator(this.fDifferences.size());
        while (it.hasPrevious()) {
            RangeDifference difference = (RangeDifference)it.previous();
            if (found == null) {
                found = difference;
            } else if (difference.kind() == 0 && (unchanged = difference.rightEnd() - Math.max(line + 1, difference.rightStart())) >= size) {
                found = difference;
            }
            if (difference.rightStart() <= line) break;
        }
        return found;
    }

    private int searchForRepetitionField(int size, IDocument doc, int line) throws BadLocationException {
        int fieldLength;
        LinkedList<String> window = new LinkedList<String>();
        int nLines = doc.getNumberOfLines();
        int repetition = line - 1;
        int l = line;
        while (l >= 0 && l < nLines) {
            IRegion r = doc.getLineInformation(l);
            String current = doc.get(r.getOffset(), r.getLength());
            if (!window.isEmpty() && window.get(0).equals(current)) {
                window.removeFirst();
                window.addLast(current);
                repetition = l;
            } else {
                if (window.size() >= size) break;
                window.addLast(current);
            }
            ++l;
        }
        Assert.isTrue(((fieldLength = repetition - line + 1) >= 0 ? 1 : 0) != 0);
        return fieldLength;
    }

    private int getLeftLine(int rightLine) {
        RangeDifference d = this.getRangeDifferenceForRightLine(rightLine);
        if (d == null) {
            return -1;
        }
        return Math.min(d.leftEnd() - 1, d.leftStart() + rightLine - d.rightStart());
    }

    private int getRightLine(int leftLine) {
        RangeDifference d = this.getRangeDifferenceForLeftLine(leftLine);
        if (d == null) {
            return -1;
        }
        return Math.min(d.rightEnd() - 1, d.rightStart() + leftLine - d.leftStart());
    }

    private RangeDifference getRangeDifferenceForLeftLine(int leftLine) {
        Iterator it = this.fDifferences.iterator();
        while (it.hasNext()) {
            RangeDifference d = (RangeDifference)it.next();
            if (leftLine < d.leftStart() || leftLine >= d.leftEnd()) continue;
            return d;
        }
        return null;
    }

    private RangeDifference getRangeDifferenceForRightLine(int rightLine) {
        Iterator it = this.fDifferences.iterator();
        while (it.hasNext()) {
            RangeDifference d = (RangeDifference)it.next();
            if (rightLine < d.rightStart() || rightLine >= d.rightEnd()) continue;
            return d;
        }
        return null;
    }

    public void addAnnotationModelListener(IAnnotationModelListener listener) {
        this.fAnnotationModelListeners.add(listener);
    }

    public void removeAnnotationModelListener(IAnnotationModelListener listener) {
        this.fAnnotationModelListeners.remove(listener);
    }

    public void connect(IDocument document) {
        Assert.isTrue((this.fRightDocument == null || this.fRightDocument == document ? 1 : 0) != 0);
        ++this.fOpenConnections;
        if (this.fOpenConnections == 1) {
            this.fRightDocument = document;
            this.initialize();
        }
    }

    public void disconnect(IDocument document) {
        Assert.isTrue((this.fRightDocument == document ? 1 : 0) != 0);
        --this.fOpenConnections;
        if (this.fOpenConnections == 0) {
            this.uninstall();
        }
    }

    private void uninstall() {
        DocumentLineDiffer documentLineDiffer = this;
        synchronized (documentLineDiffer) {
            this.fIsSynchronized = false;
            if (this.fInitializationJob != null) {
                this.fInitializationJob.cancel();
            }
            this.fInitializationJob = null;
            if (this.fLeftDocument != null) {
                this.fLeftDocument.removeDocumentListener((IDocumentListener)this);
            }
            this.fLeftDocument = null;
            if (this.fRightDocument != null) {
                this.fRightDocument.removeDocumentListener((IDocumentListener)this);
            }
            this.fRightDocument = null;
        }
        if (this.fReferenceProvider != null) {
            this.fReferenceProvider.dispose();
            this.fReferenceProvider = null;
        }
        this.fDifferences.clear();
    }

    public void addAnnotation(Annotation annotation, Position position) {
        throw new UnsupportedOperationException();
    }

    public void removeAnnotation(Annotation annotation) {
        throw new UnsupportedOperationException();
    }

    public Iterator getAnnotationIterator() {
        ArrayList copy = new ArrayList(this.fDifferences);
        final Iterator iter = copy.iterator();
        return new Iterator(){

            public void remove() {
                throw new UnsupportedOperationException();
            }

            public boolean hasNext() {
                return iter.hasNext();
            }

            public Object next() {
                RangeDifference diff = (RangeDifference)iter.next();
                return new DiffRegion(diff, 0);
            }
        };
    }

    public Position getPosition(Annotation annotation) {
        if (this.fRightDocument != null && annotation instanceof DiffRegion) {
            RangeDifference difference = ((DiffRegion)annotation).fDifference;
            try {
                int offset = this.fRightDocument.getLineOffset(difference.rightStart());
                return new Position(offset, this.fRightDocument.getLineOffset(difference.rightEnd() - 1) + this.fRightDocument.getLineLength(difference.rightEnd() - 1) - offset);
            }
            catch (BadLocationException badLocationException) {}
        }
        return null;
    }

    protected void fireModelChanged() {
        this.fireModelChanged(new AnnotationModelEvent((IAnnotationModel)this));
    }

    protected void fireModelChanged(AnnotationModelEvent event) {
        ArrayList v = new ArrayList(this.fAnnotationModelListeners);
        Iterator e = v.iterator();
        while (e.hasNext()) {
            IAnnotationModelListener l = (IAnnotationModelListener)e.next();
            if (l instanceof IAnnotationModelListenerExtension) {
                ((IAnnotationModelListenerExtension)l).modelChanged(event);
                continue;
            }
            l.modelChanged((IAnnotationModel)this);
        }
    }

    public synchronized void suspend() {
        if (this.fInitializationJob != null) {
            this.fInitializationJob.cancel();
            this.fInitializationJob = null;
        }
        if (this.fRightDocument != null) {
            this.fRightDocument.removeDocumentListener((IDocumentListener)this);
        }
        if (this.fLeftDocument != null) {
            this.fLeftDocument.removeDocumentListener((IDocumentListener)this);
        }
        this.fDifferences.clear();
        this.fIsSynchronized = false;
        this.fireModelChanged();
    }

    public synchronized void resume() {
        if (this.fRightDocument != null) {
            this.fRightDocument.addDocumentListener((IDocumentListener)this);
        }
        this.initialize();
    }

    private final class DiffRegion
    extends Annotation
    implements ILineDiffInfo {
        private RangeDifference fDifference;
        private int fOffset;

        DiffRegion(RangeDifference difference, int offset) {
            super("org.eclipse.ui.workbench.texteditor.quickdiffChange", false, null);
            this.fOffset = offset;
            this.fDifference = difference;
        }

        public String getType() {
            switch (this.getChangeType()) {
                case 2: {
                    return "org.eclipse.ui.workbench.texteditor.quickdiffChange";
                }
                case 1: {
                    return "org.eclipse.ui.workbench.texteditor.quickdiffAddition";
                }
            }
            return "org.eclipse.text.annotation.unknown";
        }

        public int getRemovedLinesBelow() {
            if (this.fOffset == this.fDifference.rightLength() - 1) {
                if (this.getChangeType() != 0) {
                    return Math.max(this.fDifference.leftLength() - this.fDifference.rightLength(), 0);
                }
                ListIterator it = DocumentLineDiffer.this.fDifferences.listIterator();
                while (it.hasNext()) {
                    RangeDifference next;
                    if (!this.fDifference.equals(it.next())) continue;
                    if (it.hasNext() && (next = (RangeDifference)it.next()).rightLength() == 0) {
                        return Math.max(next.leftLength() - next.rightLength(), 0);
                    }
                    return 0;
                }
                return 0;
            }
            return 0;
        }

        public int getChangeType() {
            if (this.fDifference.kind() == 0) {
                return 0;
            }
            if (this.fOffset >= this.fDifference.leftLength()) {
                return 1;
            }
            return 2;
        }

        public int getRemovedLinesAbove() {
            if (this.getChangeType() != 0 || this.fOffset != 0) {
                return 0;
            }
            ListIterator it = DocumentLineDiffer.this.fDifferences.listIterator(DocumentLineDiffer.this.fDifferences.size());
            while (it.hasPrevious()) {
                if (!this.fDifference.equals(it.previous())) continue;
                if (it.hasPrevious()) {
                    RangeDifference previous = (RangeDifference)it.previous();
                    return Math.max(previous.leftLength() - previous.rightLength(), 0);
                }
                return 0;
            }
            return 0;
        }

        public boolean hasChanges() {
            return this.getChangeType() != 0 || this.getRemovedLinesAbove() > 0 || this.getRemovedLinesBelow() > 0;
        }

        public String[] getOriginalText() {
            IDocument doc = DocumentLineDiffer.this.fLeftDocument;
            if (doc != null) {
                int startLine = this.fDifference.leftStart() + this.fOffset;
                if (startLine >= this.fDifference.leftEnd()) {
                    return new String[0];
                }
                int endLine = startLine + this.getRemovedLinesBelow();
                if (this.getChangeType() == 0) {
                    ++startLine;
                }
                String[] ret = new String[endLine - startLine + 1];
                int i = 0;
                while (i < ret.length) {
                    try {
                        ret[i] = doc.get(doc.getLineOffset(startLine + i), doc.getLineLength(startLine + i));
                    }
                    catch (BadLocationException badLocationException) {
                        ret[i] = new String();
                    }
                    ++i;
                }
                return ret;
            }
            return new String[0];
        }

        public String getText() {
            String changed;
            int r = this.fDifference.rightLength();
            int l = this.fDifference.leftLength();
            int c = Math.min(r, l);
            int a = r - l;
            String string = changed = c > 0 ? QuickDiffMessages.getFormattedString("quickdiff.annotation.changed", new Integer(c)) : null;
            String added = a > 0 ? QuickDiffMessages.getFormattedString("quickdiff.annotation.added", new Integer(a)) : (a < 0 ? QuickDiffMessages.getFormattedString("quickdiff.annotation.deleted", new Integer(-a)) : null);
            String line = c > 1 || c == 0 && Math.abs(a) > 1 ? QuickDiffMessages.getString("quickdiff.annotation.line_plural") : QuickDiffMessages.getString("quickdiff.annotation.line_singular");
            String ret = String.valueOf(changed != null ? changed : "") + (changed != null ? " " + line : "") + (changed != null && added != null ? ", " : " ") + (added != null ? added : "") + (added != null && changed == null ? " " + line : "");
            return ret;
        }
    }
}

