/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.texteditor;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.Assert;
import org.eclipse.ui.internal.texteditor.EditPosition;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public final class TextEditorPlugin
extends AbstractUIPlugin {
    private static TextEditorPlugin fgPlugin;
    private EditPosition fLastEditPosition;
    private Set fLastEditPositionDependentActions;
    public static final String PLUGIN_ID = "org.eclipse.ui.workbench.texteditor";

    public TextEditorPlugin(IPluginDescriptor descriptor) {
        super(descriptor);
        Assert.isTrue((fgPlugin == null ? 1 : 0) != 0);
        fgPlugin = this;
    }

    public static TextEditorPlugin getDefault() {
        return fgPlugin;
    }

    EditPosition getLastEditPosition() {
        return this.fLastEditPosition;
    }

    public void setLastEditPosition(EditPosition lastEditPosition) {
        this.fLastEditPosition = lastEditPosition;
        if (this.fLastEditPosition != null && this.fLastEditPositionDependentActions != null) {
            Iterator iter = this.fLastEditPositionDependentActions.iterator();
            while (iter.hasNext()) {
                ((IAction)iter.next()).setEnabled(true);
            }
            this.fLastEditPositionDependentActions = null;
        }
    }

    void addLastEditPositionDependentAction(IAction action) {
        if (this.fLastEditPosition != null) {
            return;
        }
        if (this.fLastEditPositionDependentActions == null) {
            this.fLastEditPositionDependentActions = new HashSet();
        }
        this.fLastEditPositionDependentActions.add(action);
    }

    void removeLastEditPositionDependentAction(IAction action) {
        if (this.fLastEditPosition != null) {
            return;
        }
        if (this.fLastEditPositionDependentActions != null) {
            this.fLastEditPositionDependentActions.remove(action);
        }
    }
}

