/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.util;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import org.eclipse.core.boot.BootLoader;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.help.IHelpContentProducer;
import org.eclipse.help.internal.HelpPlugin;
import org.eclipse.help.internal.HelpResources;

public class ResourceLocator {
    private static final Hashtable zipCache = new Hashtable();
    private static final Object ZIP_NOT_FOUND;
    private static final Object STATIC_DOCS_ONLY;
    private static Map contentProducers;

    static {
        STATIC_DOCS_ONLY = ZIP_NOT_FOUND = new Object();
        contentProducers = new HashMap(2, 0.5f);
    }

    private static IHelpContentProducer getContentProducer(IPluginDescriptor plugin) {
        Object producer = contentProducers.get(plugin);
        if (producer == null) {
            producer = ResourceLocator.createContentProducer(plugin);
            if (producer == null) {
                producer = STATIC_DOCS_ONLY;
            }
            contentProducers.put(plugin, producer);
        }
        if (producer == STATIC_DOCS_ONLY) {
            return null;
        }
        return (IHelpContentProducer)producer;
    }

    private static IHelpContentProducer createContentProducer(IPluginDescriptor plugin) {
        IExtensionPoint xp = Platform.getPluginRegistry().getExtensionPoint("org.eclipse.help.contentProducer");
        if (xp == null) {
            return null;
        }
        IExtension[] extensions = xp.getExtensions();
        int i = 0;
        while (i < extensions.length) {
            if (extensions[i].getDeclaringPluginDescriptor() == plugin) {
                IConfigurationElement[] elements = extensions[i].getConfigurationElements();
                int j = 0;
                while (j < elements.length) {
                    if ("contentProducer".equals(elements[j].getName())) {
                        try {
                            Object o = elements[j].createExecutableExtension("producer");
                            if (o instanceof IHelpContentProducer) {
                                return (IHelpContentProducer)o;
                            }
                        }
                        catch (CoreException ce) {
                            HelpPlugin.logError(HelpResources.getString("E044", plugin.getUniqueIdentifier()), ce);
                        }
                    }
                    ++j;
                }
            }
            ++i;
        }
        return null;
    }

    public static InputStream openFromProducer(IPluginDescriptor pluginDesc, String file, String locale) {
        IHelpContentProducer producer = ResourceLocator.getContentProducer(pluginDesc);
        if (producer == null) {
            return null;
        }
        if (locale == null || locale.length() <= 0) {
            locale = BootLoader.getNL();
        }
        Locale l = locale.length() >= 5 ? new Locale(locale.substring(0, 2), locale.substring(3, 5)) : (locale.length() >= 2 ? new Locale(locale.substring(0, 2), "") : Locale.getDefault());
        return producer.getInputStream(pluginDesc.getUniqueIdentifier(), file, l);
    }

    public static InputStream openFromZip(String pluginId, String zip, String file, String locale) {
        IPluginDescriptor pluginDesc = Platform.getPluginRegistry().getPluginDescriptor(pluginId);
        return ResourceLocator.openFromZip(pluginDesc, zip, file, locale);
    }

    public static InputStream openFromPlugin(String pluginId, String file, String locale) {
        IPluginDescriptor pluginDesc = Platform.getPluginRegistry().getPluginDescriptor(pluginId);
        return ResourceLocator.openFromPlugin(pluginDesc, file, locale);
    }

    public static InputStream openFromZip(IPluginDescriptor pluginDesc, String zip, String file, String locale) {
        InputStream is = ResourceLocator.doOpenFromZip(pluginDesc, "$nl$/" + zip, file, locale);
        if (is == null) {
            is = ResourceLocator.doOpenFromZip(pluginDesc, zip, file, locale);
        }
        return is;
    }

    public static InputStream openFromPlugin(IPluginDescriptor pluginDesc, String file, String locale) {
        InputStream is = ResourceLocator.doOpenFromPlugin(pluginDesc, "$nl$/" + file, locale);
        if (is == null) {
            is = ResourceLocator.doOpenFromPlugin(pluginDesc, file, locale);
        }
        return is;
    }

    private static InputStream doOpenFromZip(IPluginDescriptor pluginDesc, String zip, String file, String locale) {
        String realZipURL = ResourceLocator.findZip(pluginDesc, zip, locale);
        if (realZipURL == null) {
            return null;
        }
        try {
            URL jurl = new URL("jar", "", String.valueOf(realZipURL) + "!/" + file);
            URLConnection jconnection = jurl.openConnection();
            jconnection.setDefaultUseCaches(false);
            jconnection.setUseCaches(false);
            return jconnection.getInputStream();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private static InputStream doOpenFromPlugin(IPluginDescriptor pluginDesc, String file, String locale) {
        Path flatFilePath = new Path(file);
        HashMap<String, String> override = new HashMap<String, String>(1);
        override.put("$nl$", locale);
        try {
            URL flatFileURL = pluginDesc.getPlugin().find((IPath)flatFilePath, override);
            if (flatFileURL != null) {
                try {
                    return flatFileURL.openStream();
                }
                catch (IOException iOException) {
                    return null;
                }
            }
        }
        catch (CoreException coreException) {
            return null;
        }
        return null;
    }

    private static String findZip(IPluginDescriptor pluginDesc, String zip, String locale) {
        String pluginID = pluginDesc.getUniqueIdentifier();
        Object cached = zipCache.get(String.valueOf(pluginID) + '/' + zip + '/' + locale);
        if (cached == null) {
            Path zipFilePath = new Path(zip);
            HashMap<String, String> override = new HashMap<String, String>(1);
            override.put("$nl$", locale);
            try {
                URL zipFileURL = pluginDesc.getPlugin().find((IPath)zipFilePath, override);
                if (zipFileURL != null) {
                    URL realZipURL = Platform.resolve((URL)zipFileURL);
                    cached = realZipURL.toExternalForm();
                } else {
                    cached = ZIP_NOT_FOUND;
                }
            }
            catch (CoreException coreException) {
                cached = ZIP_NOT_FOUND;
            }
            catch (IOException iOException) {
                cached = ZIP_NOT_FOUND;
            }
            zipCache.put(String.valueOf(pluginID) + '/' + zip + '/' + locale, cached);
        }
        if (cached == ZIP_NOT_FOUND) {
            return null;
        }
        return (String)cached;
    }
}

