/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.toc;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.help.internal.toc.ITocNode;
import org.eclipse.help.internal.toc.Topic;

abstract class TocNode
implements ITocNode {
    private static final List emptyList = new ArrayList(0);
    protected List children;
    protected List parents;

    TocNode() {
    }

    public void addChild(ITocNode child) {
        if (this.children == null) {
            this.children = new ArrayList();
        }
        this.children.add(child);
        if (child instanceof TocNode) {
            ((TocNode)child).addParent(this);
        }
    }

    protected void addParent(ITocNode parent) {
        if (this.parents == null) {
            this.parents = new ArrayList();
        }
        this.parents.add(parent);
    }

    public void removeChild(ITocNode child) {
        ((TocNode)child).getParents().remove(this);
        this.getChildren().remove(child);
    }

    public List getChildren() {
        if (this.children == null) {
            return emptyList;
        }
        return this.children;
    }

    protected List getParents() {
        if (this.parents == null) {
            return emptyList;
        }
        return this.parents;
    }

    public List getChildTopics() {
        if (this.children == null) {
            return emptyList;
        }
        ArrayList<TocNode> childTopics = new ArrayList<TocNode>(this.children.size());
        Iterator childrenIt = this.children.iterator();
        while (childrenIt.hasNext()) {
            TocNode c = (TocNode)childrenIt.next();
            if (c instanceof Topic) {
                childTopics.add(c);
                continue;
            }
            childTopics.addAll(c.getChildTopics());
        }
        return childTopics;
    }
}

