/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.help.internal.context.ContextManager;
import org.eclipse.help.internal.toc.TocManager;

public class HelpPlugin
extends Plugin {
    public static final String PLUGIN_ID = "org.eclipse.help";
    public static boolean DEBUG = false;
    public static boolean DEBUG_CONTEXT = false;
    public static boolean DEBUG_PROTOCOLS = false;
    protected static HelpPlugin plugin;
    public static final String BASE_TOCS_KEY = "baseTOCS";
    protected TocManager tocManager;
    protected static Object tocManagerCreateLock;
    protected ContextManager contextManager;

    static {
        tocManagerCreateLock = new Object();
    }

    public static synchronized void logError(String message, Throwable ex) {
        if (message == null) {
            message = "";
        }
        Status errorStatus = new Status(4, PLUGIN_ID, 0, message, ex);
        HelpPlugin.getDefault().getLog().log((IStatus)errorStatus);
    }

    public static synchronized void logWarning(String message) {
        if (DEBUG) {
            if (message == null) {
                message = "";
            }
            Status warningStatus = new Status(2, PLUGIN_ID, 0, message, null);
            HelpPlugin.getDefault().getLog().log((IStatus)warningStatus);
        }
    }

    public HelpPlugin(IPluginDescriptor descriptor) {
        super(descriptor);
        plugin = this;
    }

    public static HelpPlugin getDefault() {
        return plugin;
    }

    public void shutdown() throws CoreException {
    }

    public void startup() throws CoreException {
        DEBUG = this.isDebugging();
        if (DEBUG) {
            DEBUG_CONTEXT = "true".equalsIgnoreCase(Platform.getDebugOption((String)"org.eclipse.help/debug/context"));
            DEBUG_PROTOCOLS = "true".equalsIgnoreCase(Platform.getDebugOption((String)"org.eclipse.help/debug/protocols"));
        }
    }

    public static TocManager getTocManager() {
        if (HelpPlugin.getDefault().tocManager == null) {
            Object object = tocManagerCreateLock;
            synchronized (object) {
                if (HelpPlugin.getDefault().tocManager == null) {
                    HelpPlugin.getDefault().tocManager = new TocManager();
                }
            }
        }
        return HelpPlugin.getDefault().tocManager;
    }

    public static ContextManager getContextManager() {
        if (HelpPlugin.getDefault().contextManager == null) {
            HelpPlugin.getDefault().contextManager = new ContextManager();
        }
        return HelpPlugin.getDefault().contextManager;
    }
}

