/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.runtime.registry;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.ILibrary;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.IPluginPrerequisite;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.pde.internal.runtime.OverlayIcon;
import org.eclipse.pde.internal.runtime.PDERuntimePlugin;
import org.eclipse.pde.internal.runtime.PDERuntimePluginImages;
import org.eclipse.pde.internal.runtime.registry.IPluginFolder;
import org.eclipse.pde.internal.runtime.registry.PluginObjectAdapter;
import org.eclipse.swt.graphics.Image;

public class RegistryBrowserLabelProvider
extends LabelProvider {
    private Image pluginImage = PDERuntimePluginImages.DESC_PLUGIN_OBJ.createImage();
    private Image activePluginImage;
    private Image libraryImage;
    private Image runtimeImage;
    private Image genericTagImage;
    private Image extensionImage;
    private Image extensionsImage;
    private static final String KEY_IMPORTS = "RegistryView.folders.imports";
    private static final String KEY_LIBRARIES = "RegistryView.folders.libraries";
    private static final String KEY_EXPOINTS = "RegistryView.folders.extensionPoints";
    private static final String KEY_EXTENSIONS = "RegistryView.folders.extensions";
    private Image extensionPointImage;
    private Image extensionPointsImage;
    private Image requiresImage;
    private Image reqPluginImage = PDERuntimePluginImages.DESC_REQ_PLUGIN_OBJ.createImage();

    public RegistryBrowserLabelProvider() {
        this.extensionPointImage = PDERuntimePluginImages.DESC_EXT_POINT_OBJ.createImage();
        this.extensionPointsImage = PDERuntimePluginImages.DESC_EXT_POINTS_OBJ.createImage();
        this.extensionImage = PDERuntimePluginImages.DESC_EXTENSION_OBJ.createImage();
        this.extensionsImage = PDERuntimePluginImages.DESC_EXTENSIONS_OBJ.createImage();
        this.requiresImage = PDERuntimePluginImages.DESC_REQ_PLUGINS_OBJ.createImage();
        this.libraryImage = PDERuntimePluginImages.DESC_JAVA_LIB_OBJ.createImage();
        this.genericTagImage = PDERuntimePluginImages.DESC_GENERIC_XML_OBJ.createImage();
        this.runtimeImage = PDERuntimePluginImages.DESC_RUNTIME_OBJ.createImage();
        OverlayIcon activePluginDesc = new OverlayIcon(PDERuntimePluginImages.DESC_PLUGIN_OBJ, new ImageDescriptor[][]{{PDERuntimePluginImages.DESC_RUN_CO}});
        this.activePluginImage = activePluginDesc.createImage();
    }

    public void dispose() {
        this.pluginImage.dispose();
        this.activePluginImage.dispose();
        this.reqPluginImage.dispose();
        this.extensionPointImage.dispose();
        this.extensionPointsImage.dispose();
        this.extensionImage.dispose();
        this.extensionsImage.dispose();
        this.requiresImage.dispose();
        this.libraryImage.dispose();
        this.genericTagImage.dispose();
        this.runtimeImage.dispose();
    }

    public Image getImage(Object element) {
        if (element instanceof PluginObjectAdapter) {
            element = ((PluginObjectAdapter)((Object)element)).getObject();
        }
        if (element instanceof IPluginDescriptor) {
            IPluginDescriptor pd = (IPluginDescriptor)element;
            boolean active = pd.isPluginActivated();
            return active ? this.activePluginImage : this.pluginImage;
        }
        if (element instanceof IPluginFolder) {
            int id = ((IPluginFolder)element).getFolderId();
            switch (id) {
                case 1: {
                    return this.extensionsImage;
                }
                case 2: {
                    return this.extensionPointsImage;
                }
                case 3: {
                    return this.requiresImage;
                }
                case 4: {
                    return this.runtimeImage;
                }
            }
            return null;
        }
        if (element instanceof IExtension) {
            return this.extensionImage;
        }
        if (element instanceof IExtensionPoint) {
            return this.extensionPointImage;
        }
        if (element instanceof IPluginPrerequisite) {
            return this.reqPluginImage;
        }
        if (element instanceof ILibrary) {
            return this.libraryImage;
        }
        if (element instanceof IConfigurationElement) {
            return this.genericTagImage;
        }
        return null;
    }

    public String getText(Object element) {
        if (element instanceof PluginObjectAdapter) {
            element = ((PluginObjectAdapter)((Object)element)).getObject();
        }
        if (element instanceof IPluginDescriptor) {
            return ((IPluginDescriptor)element).getLabel();
        }
        if (element instanceof IPluginFolder) {
            switch (((IPluginFolder)element).getFolderId()) {
                case 3: {
                    return PDERuntimePlugin.getResourceString(KEY_IMPORTS);
                }
                case 4: {
                    return PDERuntimePlugin.getResourceString(KEY_LIBRARIES);
                }
                case 2: {
                    return PDERuntimePlugin.getResourceString(KEY_EXPOINTS);
                }
                case 1: {
                    return PDERuntimePlugin.getResourceString(KEY_EXTENSIONS);
                }
            }
        }
        if (element instanceof IExtension) {
            return ((IExtension)element).getExtensionPointUniqueIdentifier();
        }
        if (element instanceof IExtensionPoint) {
            return ((IExtensionPoint)element).getLabel();
        }
        if (element instanceof IPluginPrerequisite) {
            return ((IPluginPrerequisite)element).getUniqueIdentifier();
        }
        if (element instanceof ILibrary) {
            return ((ILibrary)element).getPath().toString();
        }
        if (element instanceof IConfigurationElement) {
            return ((IConfigurationElement)element).getName();
        }
        return super.getText(element);
    }
}

