/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.runtime.registry;

import java.util.Hashtable;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.IPluginRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.pde.internal.runtime.registry.ConfigurationElementAdapter;
import org.eclipse.pde.internal.runtime.registry.ExtensionAdapter;
import org.eclipse.pde.internal.runtime.registry.ExtensionPointAdapter;
import org.eclipse.pde.internal.runtime.registry.IPluginFolder;
import org.eclipse.pde.internal.runtime.registry.PluginObjectAdapter;

public class RegistryBrowserContentProvider
implements ITreeContentProvider {
    private Hashtable pluginMap = new Hashtable();

    protected PluginObjectAdapter createAdapter(Object object, int id) {
        if (id == 1) {
            return new ExtensionAdapter(object);
        }
        if (id == 2) {
            return new ExtensionPointAdapter(object);
        }
        return new PluginObjectAdapter(object);
    }

    protected Object[] createPluginFolders(IPluginDescriptor pd) {
        Object[] array = new Object[]{new PluginFolder(pd, 3), new PluginFolder(pd, 4), new PluginFolder(pd, 2), new PluginFolder(pd, 1)};
        return array;
    }

    public void dispose() {
    }

    public Object[] getElements(Object element) {
        return this.getChildren(element);
    }

    public Object[] getChildren(Object element) {
        if (element instanceof ExtensionAdapter) {
            return ((ExtensionAdapter)((Object)element)).getChildren();
        }
        if (element instanceof ExtensionPointAdapter) {
            return ((ExtensionPointAdapter)((Object)element)).getChildren();
        }
        if (element instanceof ConfigurationElementAdapter) {
            return ((ConfigurationElementAdapter)((Object)element)).getChildren();
        }
        if (element instanceof PluginObjectAdapter) {
            element = ((PluginObjectAdapter)((Object)element)).getObject();
        }
        if (element.equals(Platform.getPluginRegistry())) {
            return this.getPlugins(Platform.getPluginRegistry());
        }
        if (element instanceof IPluginDescriptor) {
            IPluginDescriptor desc = (IPluginDescriptor)element;
            Object[] folders = (Object[])this.pluginMap.get(desc.getUniqueIdentifier());
            if (folders == null) {
                folders = this.createPluginFolders(desc);
                this.pluginMap.put(desc.getUniqueIdentifier(), folders);
            }
            return folders;
        }
        if (element instanceof IPluginFolder) {
            IPluginFolder folder = (IPluginFolder)element;
            return folder.getChildren();
        }
        return null;
    }

    public Object[] getPlugins(IPluginRegistry registry) {
        IPluginDescriptor[] descriptors = registry.getPluginDescriptors();
        Object[] result = new Object[descriptors.length];
        int i = 0;
        while (i < descriptors.length) {
            result[i] = new PluginObjectAdapter(descriptors[i]);
            ++i;
        }
        return result;
    }

    private Object[] getFolderChildren(IPluginDescriptor pd, int id) {
        Object[] array = null;
        switch (id) {
            case 1: {
                array = pd.getExtensions();
                break;
            }
            case 2: {
                array = pd.getExtensionPoints();
                break;
            }
            case 3: {
                array = pd.getPluginPrerequisites();
                break;
            }
            case 4: {
                array = pd.getRuntimeLibraries();
            }
        }
        Object[] result = null;
        if (array != null && array.length > 0) {
            result = new Object[array.length];
            int i = 0;
            while (i < array.length) {
                result[i] = this.createAdapter(array[i], id);
                ++i;
            }
        }
        return result;
    }

    public Object getParent(Object element) {
        return null;
    }

    public boolean hasChildren(Object element) {
        Object[] children = this.getChildren(element);
        return children != null && children.length > 0;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public boolean isDeleted(Object element) {
        return false;
    }

    class PluginFolder
    implements IPluginFolder {
        private int id;
        IPluginDescriptor pd;
        private Object[] children;

        public PluginFolder(IPluginDescriptor pd, int id) {
            this.pd = pd;
            this.id = id;
        }

        public IPluginDescriptor getPluginDescriptor() {
            return this.pd;
        }

        public Object[] getChildren() {
            if (this.children == null) {
                this.children = RegistryBrowserContentProvider.this.getFolderChildren(this.pd, this.id);
            }
            return this.children;
        }

        public int getFolderId() {
            return this.id;
        }

        public Object getAdapter(Class key) {
            return null;
        }
    }
}

