/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.runtime.logview;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import org.eclipse.core.runtime.ILogListener;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableTreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.pde.internal.runtime.PDERuntimePlugin;
import org.eclipse.pde.internal.runtime.PDERuntimePluginImages;
import org.eclipse.pde.internal.runtime.logview.DetailsForm;
import org.eclipse.pde.internal.runtime.logview.FilterDialog;
import org.eclipse.pde.internal.runtime.logview.LogEntry;
import org.eclipse.pde.internal.runtime.logview.LogReader;
import org.eclipse.pde.internal.runtime.logview.LogViewContentProvider;
import org.eclipse.pde.internal.runtime.logview.LogViewLabelProvider;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.TableTree;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.XMLMemento;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.dialogs.PropertyDialogAction;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.part.ViewPart;

public class LogView
extends ViewPart
implements ILogListener {
    private TableTreeViewer tableTreeViewer;
    private DetailsForm detailsForm;
    private ArrayList logs = new ArrayList();
    public static final String P_LOG_WARNING = "warning";
    public static final String P_LOG_ERROR = "error";
    public static final String P_LOG_INFO = "info";
    public static final String P_LOG_LIMIT = "limit";
    public static final String P_USE_LIMIT = "useLimit";
    public static final String P_SHOW_ALL_SESSIONS = "allSessions";
    private static final String P_COLUMN_1 = "column1";
    private static final String P_COLUMN_2 = "column2";
    private static final String P_COLUMN_3 = "column3";
    private static final String P_COLUMN_4 = "column4";
    public static final String P_ACTIVATE = "activate";
    public static final String P_SHOW_DETAILS = "showDetails";
    public static final String P_COLLAPSE_SESSION = "collapseSession";
    public static final String P_COLLAPSE_STACK = "collapseStack";
    private int MESSAGE_ORDER = -1;
    private int PLUGIN_ORDER = -1;
    private int DATE_ORDER = -1;
    private static int ASCENDING = 1;
    private static int DESCENDING = -1;
    private Action clearAction;
    private Action copyAction;
    private Action readLogAction;
    private Action deleteLogAction;
    private Action exportAction;
    private Action importAction;
    private Action activateViewAction;
    private Action showPreviewAction;
    private Action propertiesAction;
    private Action filterAction;
    private Clipboard clipboard;
    private IMemento memento;
    private File inputFile = Platform.getLogFileLocation().toFile();
    private String directory;
    private TableColumn column1;
    private TableColumn column2;
    private TableColumn column3;
    private TableColumn column4;
    private Composite leftContainer;
    private SashForm sashForm;
    private boolean firstEvent = true;
    static /* synthetic */ Class class$0;

    public void createPartControl(Composite parent) {
        this.readLogFile();
        this.sashForm = new SashForm(parent, 256);
        this.sashForm.setLayout((Layout)new GridLayout());
        this.sashForm.setLayoutData((Object)new GridData(1808));
        this.createTableSection((Composite)this.sashForm);
        this.createDetailsSection((Composite)this.sashForm);
        if (!this.showPreviewAction.isChecked()) {
            this.sashForm.setMaximizedControl((Control)this.leftContainer);
        }
    }

    private void createTableSection(Composite parent) {
        this.leftContainer = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 2;
        layout.horizontalSpacing = 0;
        this.leftContainer.setLayout((Layout)layout);
        TableTree tableTree = new TableTree(this.leftContainer, 65536);
        tableTree.setLayoutData((Object)new GridData(1808));
        this.createColumns(tableTree.getTable());
        this.createViewer(tableTree);
        this.createVerticalLine(this.leftContainer);
        this.createPopupMenuManager(tableTree);
        this.makeActions(tableTree.getTable());
        this.fillToolBar();
        Platform.addLogListener((ILogListener)this);
        this.getSite().setSelectionProvider((ISelectionProvider)this.tableTreeViewer);
        this.clipboard = new Clipboard(tableTree.getDisplay());
        WorkbenchHelp.setHelp((Control)tableTree, (String)"org.eclipse.pde.doc.user.log_view");
    }

    private void createDetailsSection(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 2;
        layout.horizontalSpacing = 0;
        container.setLayout((Layout)layout);
        container.setLayoutData((Object)new GridData(1808));
        this.createVerticalLine(container);
        this.detailsForm = new DetailsForm(this.memento);
        Control formControl = this.detailsForm.createControl(container);
        formControl.setLayoutData((Object)new GridData(1808));
        if (this.logs.size() > 0) {
            this.tableTreeViewer.setSelection((ISelection)new StructuredSelection(this.logs.get(0)));
        } else {
            this.detailsForm.openTo(null);
        }
        this.detailsForm.update();
    }

    private void createVerticalLine(Composite parent) {
        Label line = new Label(parent, 514);
        GridData gd = new GridData(1040);
        gd.widthHint = 1;
        line.setLayoutData((Object)gd);
    }

    private void fillToolBar() {
        IActionBars bars = this.getViewSite().getActionBars();
        bars.setGlobalActionHandler(ActionFactory.COPY.getId(), (IAction)this.copyAction);
        IToolBarManager toolBarManager = bars.getToolBarManager();
        toolBarManager.add((IAction)this.exportAction);
        toolBarManager.add((IAction)this.importAction);
        toolBarManager.add((IContributionItem)new Separator());
        toolBarManager.add((IAction)this.deleteLogAction);
        toolBarManager.add((IAction)this.clearAction);
        toolBarManager.add((IAction)this.readLogAction);
        toolBarManager.add((IContributionItem)new Separator());
        IMenuManager mgr = bars.getMenuManager();
        mgr.add((IAction)this.filterAction);
        mgr.add((IContributionItem)new Separator());
        mgr.add((IAction)this.showPreviewAction);
        mgr.add((IAction)this.activateViewAction);
    }

    private void createViewer(TableTree tableTree) {
        this.tableTreeViewer = new TableTreeViewer(tableTree);
        this.tableTreeViewer.setContentProvider((IContentProvider)new LogViewContentProvider(this));
        this.tableTreeViewer.setLabelProvider((IBaseLabelProvider)new LogViewLabelProvider());
        this.tableTreeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent e) {
                LogView.this.handleSelectionChanged(e.getSelection());
            }
        });
        this.tableTreeViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                LogView.this.propertiesAction.run();
            }
        });
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("[Lorg.eclipse.core.runtime.Platform;").getComponentType();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.tableTreeViewer.setInput((Object)clazz);
    }

    private void createPopupMenuManager(TableTree tableTree) {
        MenuManager popupMenuManager = new MenuManager();
        IMenuListener listener = new IMenuListener(){

            public void menuAboutToShow(IMenuManager mng) {
                LogView.this.fillContextMenu(mng);
            }
        };
        popupMenuManager.addMenuListener(listener);
        popupMenuManager.setRemoveAllWhenShown(true);
        Menu menu = popupMenuManager.createContextMenu((Control)tableTree);
        tableTree.setMenu(menu);
    }

    private void createColumns(Table table) {
        TableColumn column = new TableColumn(table, 0);
        column.setText("");
        this.column1 = new TableColumn(table, 0);
        this.column1.setText(PDERuntimePlugin.getResourceString("LogView.column.severity"));
        this.column2 = new TableColumn(table, 0);
        this.column2.setText(PDERuntimePlugin.getResourceString("LogView.column.message"));
        this.column2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LogView logView = LogView.this;
                logView.MESSAGE_ORDER = logView.MESSAGE_ORDER * -1;
                LogView.this.tableTreeViewer.setSorter(new ViewerSorter(this){
                    final /* synthetic */ 4 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public int compare(Viewer viewer, Object e1, Object e2) {
                        LogEntry entry1 = (LogEntry)((Object)e1);
                        LogEntry entry2 = (LogEntry)((Object)e2);
                        return super.compare(viewer, (Object)entry1.getMessage(), (Object)entry2.getMessage()) * LogView.access$2(4.access$0(this.this$1));
                    }
                });
            }

            static /* synthetic */ LogView access$0(4 var0) {
                return var0.LogView.this;
            }
        });
        this.column3 = new TableColumn(table, 0);
        this.column3.setText(PDERuntimePlugin.getResourceString("LogView.column.plugin"));
        this.column3.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LogView logView = LogView.this;
                logView.PLUGIN_ORDER = logView.PLUGIN_ORDER * -1;
                LogView.this.tableTreeViewer.setSorter(new ViewerSorter(this){
                    final /* synthetic */ 6 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public int compare(Viewer viewer, Object e1, Object e2) {
                        LogEntry entry1 = (LogEntry)((Object)e1);
                        LogEntry entry2 = (LogEntry)((Object)e2);
                        return super.compare(viewer, (Object)entry1.getPluginId(), (Object)entry2.getPluginId()) * LogView.access$5(6.access$0(this.this$1));
                    }
                });
            }

            static /* synthetic */ LogView access$0(6 var0) {
                return var0.LogView.this;
            }
        });
        this.column4 = new TableColumn(table, 0);
        this.column4.setText(PDERuntimePlugin.getResourceString("LogView.column.date"));
        this.column4.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (LogView.this.DATE_ORDER == ASCENDING) {
                    LogView.this.DATE_ORDER = DESCENDING;
                } else {
                    LogView.this.DATE_ORDER = ASCENDING;
                }
                LogView.this.tableTreeViewer.setSorter(new ViewerSorter(this){
                    final /* synthetic */ 8 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public int compare(Viewer viewer, Object e1, Object e2) {
                        try {
                            SimpleDateFormat formatter = new SimpleDateFormat("MMM dd, yyyy HH:mm:ss.SS");
                            Date date1 = formatter.parse(((LogEntry)((Object)e1)).getDate());
                            Date date2 = formatter.parse(((LogEntry)((Object)e2)).getDate());
                            if (LogView.access$7(8.access$0(this.this$1)) == LogView.access$8()) {
                                return date1.before(date2) ? -1 : 1;
                            }
                            return date1.after(date2) ? -1 : 1;
                        }
                        catch (ParseException parseException) {
                            return 0;
                        }
                    }
                });
            }

            static /* synthetic */ LogView access$0(8 var0) {
                return var0.LogView.this;
            }
        });
        TableLayout tlayout = new TableLayout();
        tlayout.addColumnData((ColumnLayoutData)new ColumnPixelData(21));
        tlayout.addColumnData((ColumnLayoutData)new ColumnPixelData(this.memento.getInteger(P_COLUMN_1).intValue()));
        tlayout.addColumnData((ColumnLayoutData)new ColumnPixelData(this.memento.getInteger(P_COLUMN_2).intValue()));
        tlayout.addColumnData((ColumnLayoutData)new ColumnPixelData(this.memento.getInteger(P_COLUMN_3).intValue()));
        tlayout.addColumnData((ColumnLayoutData)new ColumnPixelData(this.memento.getInteger(P_COLUMN_4).intValue()));
        table.setLayout((Layout)tlayout);
        table.setHeaderVisible(true);
    }

    private void makeActions(Table table) {
        this.propertiesAction = new PropertyDialogAction(table.getShell(), (ISelectionProvider)this.tableTreeViewer);
        this.propertiesAction.setImageDescriptor(PDERuntimePluginImages.DESC_PROPERTIES);
        this.propertiesAction.setDisabledImageDescriptor(PDERuntimePluginImages.DESC_PROPERTIES_DISABLED);
        this.propertiesAction.setHoverImageDescriptor(PDERuntimePluginImages.DESC_PROPERTIES_HOVER);
        this.propertiesAction.setToolTipText(PDERuntimePlugin.getResourceString("LogView.properties.tooltip"));
        this.propertiesAction.setEnabled(false);
        this.clearAction = new Action(PDERuntimePlugin.getResourceString("LogView.clear")){

            public void run() {
                LogView.this.handleClear();
            }
        };
        this.clearAction.setImageDescriptor(PDERuntimePluginImages.DESC_CLEAR);
        this.clearAction.setDisabledImageDescriptor(PDERuntimePluginImages.DESC_CLEAR_DISABLED);
        this.clearAction.setHoverImageDescriptor(PDERuntimePluginImages.DESC_CLEAR_HOVER);
        this.clearAction.setToolTipText(PDERuntimePlugin.getResourceString("LogView.clear"));
        this.clearAction.setText(PDERuntimePlugin.getResourceString("LogView.clear"));
        this.readLogAction = new Action(PDERuntimePlugin.getResourceString("LogView.readLog.restore")){

            public void run() {
                LogView.this.inputFile = Platform.getLogFileLocation().toFile();
                LogView.this.reloadLog();
            }
        };
        this.readLogAction.setToolTipText(PDERuntimePlugin.getResourceString("LogView.readLog.restore"));
        this.readLogAction.setImageDescriptor(PDERuntimePluginImages.DESC_READ_LOG);
        this.readLogAction.setDisabledImageDescriptor(PDERuntimePluginImages.DESC_READ_LOG_DISABLED);
        this.readLogAction.setHoverImageDescriptor(PDERuntimePluginImages.DESC_READ_LOG_HOVER);
        this.deleteLogAction = new Action(PDERuntimePlugin.getResourceString("LogView.delete")){

            public void run() {
                LogView.this.doDeleteLog();
            }
        };
        this.deleteLogAction.setToolTipText(PDERuntimePlugin.getResourceString("LogView.delete"));
        this.deleteLogAction.setImageDescriptor(PDERuntimePluginImages.DESC_REMOVE_LOG);
        this.deleteLogAction.setDisabledImageDescriptor(PDERuntimePluginImages.DESC_REMOVE_LOG_DISABLED);
        this.deleteLogAction.setHoverImageDescriptor(PDERuntimePluginImages.DESC_REMOVE_LOG_HOVER);
        this.deleteLogAction.setEnabled(this.inputFile.exists() && this.inputFile.equals(Platform.getLogFileLocation().toFile()));
        this.copyAction = new Action(PDERuntimePlugin.getResourceString("LogView.copy")){

            public void run() {
                if (LogView.this.detailsForm.hasFocus()) {
                    LogView.this.detailsForm.doGlobalAction(ActionFactory.COPY.getId());
                } else {
                    LogView.this.copyToClipboard(LogView.this.tableTreeViewer.getSelection());
                }
            }
        };
        this.copyAction.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_COPY"));
        this.copyAction.setDisabledImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_COPY_DISABLED"));
        this.copyAction.setHoverImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_COPY_HOVER"));
        this.filterAction = new Action(PDERuntimePlugin.getResourceString("LogView.filter")){

            public void run() {
                LogView.this.handleFilter();
            }
        };
        this.filterAction.setToolTipText(PDERuntimePlugin.getResourceString("LogView.filter"));
        this.filterAction.setImageDescriptor(PDERuntimePluginImages.DESC_FILTER);
        this.filterAction.setDisabledImageDescriptor(PDERuntimePluginImages.DESC_FILTER_DISABLED);
        this.filterAction.setHoverImageDescriptor(PDERuntimePluginImages.DESC_FILTER_HOVER);
        this.exportAction = new Action(PDERuntimePlugin.getResourceString("LogView.export")){

            public void run() {
                LogView.this.handleExport();
            }
        };
        this.exportAction.setToolTipText(PDERuntimePlugin.getResourceString("LogView.export.tooltip"));
        this.exportAction.setImageDescriptor(PDERuntimePluginImages.DESC_EXPORT);
        this.exportAction.setDisabledImageDescriptor(PDERuntimePluginImages.DESC_EXPORT_DISABLED);
        this.exportAction.setHoverImageDescriptor(PDERuntimePluginImages.DESC_EXPORT_HOVER);
        this.importAction = new Action(PDERuntimePlugin.getResourceString("LogView.import")){

            public void run() {
                LogView.this.handleImport();
            }
        };
        this.importAction.setToolTipText(PDERuntimePlugin.getResourceString("LogView.import.tooltip"));
        this.importAction.setImageDescriptor(PDERuntimePluginImages.DESC_IMPORT);
        this.importAction.setDisabledImageDescriptor(PDERuntimePluginImages.DESC_IMPORT_DISABLED);
        this.importAction.setHoverImageDescriptor(PDERuntimePluginImages.DESC_IMPORT_HOVER);
        this.activateViewAction = new Action(PDERuntimePlugin.getResourceString("LogView.activate")){

            public void run() {
            }
        };
        this.activateViewAction.setChecked(this.memento.getString(P_ACTIVATE).equals("true"));
        this.showPreviewAction = new Action(PDERuntimePlugin.getResourceString("LogView.showDetails")){

            public void run() {
                LogView.this.memento.putString(LogView.P_SHOW_DETAILS, this.isChecked() ? "true" : "false");
                if (this.isChecked()) {
                    LogView.this.sashForm.setMaximizedControl(null);
                    LogView.this.handleSelectionChanged(LogView.this.tableTreeViewer.getSelection());
                } else {
                    LogView.this.sashForm.setMaximizedControl((Control)LogView.this.leftContainer);
                }
            }
        };
        this.showPreviewAction.setChecked(this.memento.getString(P_SHOW_DETAILS).equals("true"));
    }

    public void dispose() {
        Platform.removeLogListener((ILogListener)this);
        this.clipboard.dispose();
        this.detailsForm.dispose();
        LogReader.reset();
        super.dispose();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void handleImport() {
        String path;
        FileDialog dialog = new FileDialog(this.getViewSite().getShell());
        dialog.setFilterExtensions(new String[]{"*.log"});
        if (this.directory != null) {
            dialog.setFilterPath(this.directory);
        }
        if ((path = dialog.open()) == null) return;
        if (!new Path(path).toFile().exists()) return;
        this.inputFile = new Path(path).toFile();
        this.directory = this.inputFile.getParent();
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                monitor.beginTask(PDERuntimePlugin.getResourceString("LogView.operation.importing"), -1);
                LogView.this.readLogFile();
            }
        };
        ProgressMonitorDialog pmd = new ProgressMonitorDialog(this.getViewSite().getShell());
        try {
            try {
                pmd.run(true, true, op);
            }
            catch (InvocationTargetException invocationTargetException) {
            }
            catch (InterruptedException interruptedException) {}
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            this.readLogAction.setText(PDERuntimePlugin.getResourceString("LogView.readLog.reload"));
            this.readLogAction.setToolTipText(PDERuntimePlugin.getResourceString("LogView.readLog.reload"));
            this.asyncRefresh(false);
            throw throwable;
        }
        {
            Object var5_7 = null;
        }
        this.readLogAction.setText(PDERuntimePlugin.getResourceString("LogView.readLog.reload"));
        this.readLogAction.setToolTipText(PDERuntimePlugin.getResourceString("LogView.readLog.reload"));
        this.asyncRefresh(false);
    }

    private void handleExport() {
        String path;
        FileDialog dialog = new FileDialog(this.getViewSite().getShell());
        dialog.setFilterExtensions(new String[]{"*.log"});
        if (this.directory != null) {
            dialog.setFilterPath(this.directory);
        }
        if ((path = dialog.open()) != null) {
            if (!path.endsWith(".log")) {
                path = String.valueOf(path) + ".log";
            }
            File outputFile = new Path(path).toFile();
            this.directory = outputFile.getParent();
            if (outputFile.exists()) {
                String message = PDERuntimePlugin.getFormattedMessage("LogView.confirmOverwrite.message", outputFile.toString());
                if (!MessageDialog.openQuestion((Shell)this.getViewSite().getShell(), (String)this.exportAction.getText(), (String)message)) {
                    return;
                }
            }
            this.copy(this.inputFile, outputFile);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void copy(File inputFile, File outputFile) {
        BufferedReader reader = null;
        BufferedWriter writer = null;
        try {
            try {
                reader = new BufferedReader(new FileReader(inputFile));
                writer = new BufferedWriter(new FileWriter(outputFile));
                while (reader.ready()) {
                    writer.write(reader.readLine());
                    writer.write(System.getProperty("line.separator"));
                }
            }
            catch (IOException iOException) {}
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            try {
                if (reader != null) {
                    reader.close();
                }
                if (writer == null) throw throwable;
                writer.close();
                throw throwable;
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        {
            Object var5_7 = null;
        }
        try {}
        catch (IOException iOException) {
            return;
        }
        if (reader != null) {
            reader.close();
        }
        if (writer == null) return;
        writer.close();
    }

    private void handleFilter() {
        FilterDialog dialog = new FilterDialog(PDERuntimePlugin.getActiveWorkbenchShell(), this.memento);
        dialog.create();
        dialog.getShell().setText(PDERuntimePlugin.getResourceString("LogView.FilterDialog.title"));
        if (dialog.open() == 0) {
            this.reloadLog();
        }
    }

    private void doDeleteLog() {
        String title = PDERuntimePlugin.getResourceString("LogView.confirmDelete.title");
        String message = PDERuntimePlugin.getResourceString("LogView.confirmDelete.message");
        if (!MessageDialog.openConfirm((Shell)this.tableTreeViewer.getControl().getShell(), (String)title, (String)message)) {
            return;
        }
        if (this.inputFile.delete()) {
            this.logs.clear();
            this.asyncRefresh(false);
        }
    }

    public void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)this.copyAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.clearAction);
        manager.add((IAction)this.deleteLogAction);
        manager.add((IAction)this.readLogAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.exportAction);
        manager.add((IAction)this.importAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.propertiesAction);
    }

    public LogEntry[] getLogs() {
        return this.logs.toArray(new LogEntry[this.logs.size()]);
    }

    protected void handleClear() {
        BusyIndicator.showWhile((Display)this.tableTreeViewer.getControl().getDisplay(), (Runnable)new Runnable(){

            public void run() {
                LogView.this.logs.clear();
                LogView.this.asyncRefresh(false);
            }
        });
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void reloadLog() {
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                monitor.beginTask(PDERuntimePlugin.getResourceString("LogView.operation.reloading"), -1);
                LogView.this.readLogFile();
            }
        };
        ProgressMonitorDialog pmd = new ProgressMonitorDialog(this.getViewSite().getShell());
        try {
            try {
                pmd.run(true, true, op);
            }
            catch (InvocationTargetException invocationTargetException) {
            }
            catch (InterruptedException interruptedException) {}
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.readLogAction.setText(PDERuntimePlugin.getResourceString("LogView.readLog.restore"));
            this.readLogAction.setToolTipText(PDERuntimePlugin.getResourceString("LogView.readLog.restore"));
            this.asyncRefresh(false);
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        this.readLogAction.setText(PDERuntimePlugin.getResourceString("LogView.readLog.restore"));
        this.readLogAction.setToolTipText(PDERuntimePlugin.getResourceString("LogView.readLog.restore"));
        this.asyncRefresh(false);
    }

    private void readLogFile() {
        this.logs.clear();
        if (!this.inputFile.exists()) {
            return;
        }
        LogReader.parseLogFile(this.inputFile, this.logs, this.memento);
    }

    public void logging(IStatus status, String plugin) {
        if (!this.inputFile.equals(Platform.getLogFileLocation().toFile())) {
            return;
        }
        if (this.firstEvent) {
            this.readLogFile();
            this.asyncRefresh();
            this.firstEvent = false;
        } else {
            this.pushStatus(status);
        }
    }

    private void pushStatus(IStatus status) {
        LogEntry entry = new LogEntry(status);
        LogReader.addEntry(entry, this.logs, this.memento, true);
        this.asyncRefresh();
    }

    private void asyncRefresh() {
        this.asyncRefresh(true);
    }

    private void asyncRefresh(final boolean activate) {
        final Control control = this.tableTreeViewer.getControl();
        if (control.isDisposed()) {
            return;
        }
        Display display = control.getDisplay();
        final LogView view = this;
        if (display != null) {
            display.asyncExec(new Runnable(){

                public void run() {
                    if (!control.isDisposed()) {
                        IWorkbenchPage page;
                        LogView.this.tableTreeViewer.refresh();
                        LogView.this.deleteLogAction.setEnabled(LogView.this.inputFile.exists() && LogView.this.inputFile.equals(Platform.getLogFileLocation().toFile()));
                        if (activate && LogView.this.activateViewAction.isChecked() && (page = PDERuntimePlugin.getActivePage()) != null) {
                            page.activate((IWorkbenchPart)view);
                        }
                    }
                }
            });
        }
    }

    public void setFocus() {
        this.tableTreeViewer.getTableTree().getTable().setFocus();
    }

    private void handleSelectionChanged(ISelection selection) {
        this.updateStatus(selection);
        this.updatePreview(selection);
        this.copyAction.setEnabled(!selection.isEmpty());
        this.propertiesAction.setEnabled(!selection.isEmpty());
    }

    private void updatePreview(ISelection selection) {
        if (!this.showPreviewAction.isChecked()) {
            return;
        }
        if (selection.isEmpty()) {
            this.detailsForm.openTo(null);
        } else {
            this.detailsForm.openTo((LogEntry)((Object)((IStructuredSelection)selection).getFirstElement()));
        }
    }

    private void updateStatus(ISelection selection) {
        IStatusLineManager status = this.getViewSite().getActionBars().getStatusLineManager();
        if (selection.isEmpty()) {
            status.setMessage(null);
        } else {
            LogEntry entry = (LogEntry)((Object)((IStructuredSelection)selection).getFirstElement());
            status.setMessage(((LogViewLabelProvider)this.tableTreeViewer.getLabelProvider()).getColumnText((Object)entry, 2));
        }
    }

    private void copyToClipboard(ISelection selection) {
        StringWriter writer = new StringWriter();
        PrintWriter pwriter = new PrintWriter(writer);
        if (selection.isEmpty()) {
            return;
        }
        LogEntry entry = (LogEntry)((Object)((IStructuredSelection)selection).getFirstElement());
        entry.write(pwriter);
        pwriter.flush();
        String textVersion = writer.toString();
        try {
            pwriter.close();
            writer.close();
        }
        catch (IOException iOException) {}
        this.clipboard.setContents(new Object[]{textVersion}, new Transfer[]{TextTransfer.getInstance()});
    }

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        super.init(site, memento);
        this.memento = memento == null ? XMLMemento.createWriteRoot((String)"LOGVIEW") : memento;
        this.initializeMemento();
    }

    private void initializeMemento() {
        Integer width;
        if (this.memento.getString(P_USE_LIMIT) == null) {
            this.memento.putString(P_USE_LIMIT, "true");
        }
        if (this.memento.getInteger(P_LOG_LIMIT) == null) {
            this.memento.putInteger(P_LOG_LIMIT, 50);
        }
        if (this.memento.getString(P_LOG_INFO) == null) {
            this.memento.putString(P_LOG_INFO, "true");
        }
        if (this.memento.getString(P_LOG_WARNING) == null) {
            this.memento.putString(P_LOG_WARNING, "true");
        }
        if (this.memento.getString(P_LOG_ERROR) == null) {
            this.memento.putString(P_LOG_ERROR, "true");
        }
        if (this.memento.getString(P_SHOW_ALL_SESSIONS) == null) {
            this.memento.putString(P_SHOW_ALL_SESSIONS, "true");
        }
        if ((width = this.memento.getInteger(P_COLUMN_1)) == null || width == 0) {
            this.memento.putInteger(P_COLUMN_1, 20);
        }
        if ((width = this.memento.getInteger(P_COLUMN_2)) == null || width == 0) {
            this.memento.putInteger(P_COLUMN_2, 150);
        }
        if ((width = this.memento.getInteger(P_COLUMN_3)) == null || width == 0) {
            this.memento.putInteger(P_COLUMN_3, 150);
        }
        if ((width = this.memento.getInteger(P_COLUMN_4)) == null || width == 0) {
            this.memento.putInteger(P_COLUMN_4, 150);
        }
        if (this.memento.getString(P_ACTIVATE) == null) {
            this.memento.putString(P_ACTIVATE, "true");
        }
        if (this.memento.getString(P_SHOW_DETAILS) == null) {
            this.memento.putString(P_SHOW_DETAILS, "false");
        }
        if (this.memento.getString(P_COLLAPSE_SESSION) == null) {
            this.memento.putString(P_COLLAPSE_SESSION, "true");
        }
        if (this.memento.getString(P_COLLAPSE_STACK) == null) {
            this.memento.putString(P_COLLAPSE_STACK, "true");
        }
    }

    public void saveState(IMemento memento) {
        this.memento.putInteger(P_COLUMN_1, this.column1.getWidth());
        this.memento.putInteger(P_COLUMN_2, this.column2.getWidth());
        this.memento.putInteger(P_COLUMN_3, this.column3.getWidth());
        this.memento.putInteger(P_COLUMN_4, this.column4.getWidth());
        this.memento.putString(P_ACTIVATE, this.activateViewAction.isChecked() ? "true" : "false");
        this.detailsForm.saveState();
        memento.putMemento(this.memento);
    }
}

