/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.runtime.logview;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.pde.internal.runtime.PDERuntimePlugin;
import org.eclipse.pde.internal.runtime.logview.LogEntry;
import org.eclipse.pde.internal.runtime.logview.LogViewLabelProvider;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.PropertyPage;

public class LogEntryPropertyPage
extends PropertyPage {
    private LogViewLabelProvider labelProvider = new LogViewLabelProvider();

    public LogEntryPropertyPage() {
        this.noDefaultAndApplyButton();
    }

    protected Control createContents(Composite parent) {
        LogEntry entry = (LogEntry)this.getElement();
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        container.setLayout((Layout)layout);
        Label label = new Label(container, 0);
        label.setText(PDERuntimePlugin.getResourceString("LogEntryPropertyPage.date"));
        label = new Label(container, 0);
        label.setText(entry.getDate());
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        label.setLayoutData((Object)gd);
        label = new Label(container, 0);
        label.setText(PDERuntimePlugin.getResourceString("LogEntryPropertyPage.severity"));
        label = new Label(container, 0);
        label.setImage(this.labelProvider.getColumnImage((Object)entry, 1));
        label = new Label(container, 0);
        gd = new GridData(768);
        label.setText(entry.getSeverityText());
        label.setLayoutData((Object)gd);
        label = new Label(container, 0);
        label.setText(PDERuntimePlugin.getResourceString("LogEntryPropertyPage.message"));
        gd = new GridData(2);
        label.setLayoutData((Object)gd);
        label = new Label(container, 64);
        label.setText(entry.getMessage());
        gd = new GridData(770);
        gd.widthHint = this.computeWidthLimit(label, 80);
        gd.horizontalSpan = 2;
        label.setLayoutData((Object)gd);
        String stack = entry.getStack();
        if (stack != null) {
            label = new Label(container, 0);
            label.setText(PDERuntimePlugin.getResourceString("LogEntryPropertyPage.exception"));
            gd = new GridData(768);
            gd.horizontalSpan = 3;
            label.setLayoutData((Object)gd);
            Text text = new Text(container, 2818);
            gd = new GridData(1808);
            gd.horizontalSpan = 3;
            gd.widthHint = 300;
            gd.heightHint = 300;
            text.setLayoutData((Object)gd);
            text.setText(stack);
        }
        return container;
    }

    public void dispose() {
        this.labelProvider.dispose();
        super.dispose();
    }

    private int computeWidthLimit(Label label, int nchars) {
        GC gc = new GC((Drawable)label);
        gc.setFont(label.getFont());
        FontMetrics fontMetrics = gc.getFontMetrics();
        gc.dispose();
        return Dialog.convertWidthInCharsToPixels((FontMetrics)fontMetrics, (int)nchars);
    }
}

