/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.runtime.logview;

import org.eclipse.pde.internal.runtime.PDERuntimePlugin;
import org.eclipse.pde.internal.runtime.PDERuntimePluginImages;
import org.eclipse.pde.internal.runtime.logview.LogEntry;
import org.eclipse.pde.internal.runtime.logview.SessionDataSection;
import org.eclipse.pde.internal.runtime.logview.StackSection;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IMemento;
import org.eclipse.update.ui.forms.internal.ScrollableSectionForm;

public class DetailsForm
extends ScrollableSectionForm {
    private SessionDataSection sessionSection;
    private StackSection stackSection;
    private Image headingImage;
    private Label date;
    private Text message;
    private Composite parent;
    private Label eventType;
    private IMemento memento;

    public DetailsForm(IMemento memento) {
        this.setVerticalFit(true);
        this.memento = memento;
        this.headingImage = PDERuntimePluginImages.DESC_FORM_BANNER_SHORT.createImage();
        if (this.isWhiteBackground()) {
            this.setHeadingImage(this.headingImage);
        }
        this.setHeadingText(PDERuntimePlugin.getResourceString("logView.preview.header"));
    }

    private boolean isWhiteBackground() {
        Color color = this.factory.getBackgroundColor();
        return color.getRed() == 255 && color.getGreen() == 255 && color.getBlue() == 255;
    }

    public void openTo(LogEntry entry) {
        if (entry == null) {
            this.parent.setVisible(false);
        } else {
            this.parent.setVisible(true);
            this.sessionSection.expandTo((Object)entry);
            this.stackSection.expandTo((Object)entry);
            this.updateTopSection(entry);
        }
        this.update();
    }

    protected void createFormClient(Composite parent) {
        this.parent = parent;
        GridLayout layout = new GridLayout();
        layout.marginWidth = 5;
        layout.marginHeight = 0;
        layout.verticalSpacing = 15;
        parent.setLayout((Layout)layout);
        parent.setLayoutData((Object)new GridData(1808));
        this.createTopSection(parent);
        this.stackSection = new StackSection(this, this.memento.getString("collapseStack").equals("true"));
        Control control = this.stackSection.createControl(parent, this.factory);
        control.setLayoutData((Object)new GridData(784));
        this.sessionSection = new SessionDataSection(this, this.memento.getString("collapseSession").equals("true"));
        control = this.sessionSection.createControl(parent, this.factory);
        control.setLayoutData((Object)new GridData(770));
        this.registerSection(this.sessionSection);
        this.registerSection(this.stackSection);
    }

    private void createTopSection(Composite parent) {
        Composite comp = this.factory.createComposite(parent);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        comp.setLayout((Layout)layout);
        comp.setLayoutData((Object)new GridData(770));
        this.eventType = this.factory.createLabel(comp, "", 0);
        GridData gd = new GridData();
        gd.horizontalSpan = 2;
        this.eventType.setLayoutData((Object)gd);
        this.date = this.factory.createLabel(comp, "", 0);
        gd = new GridData();
        gd.horizontalSpan = 2;
        this.date.setLayoutData((Object)gd);
        Label label = this.factory.createLabel(comp, PDERuntimePlugin.getResourceString("LogView.preview.message"), 0);
        label.setLayoutData((Object)new GridData(2));
        this.message = new Text(comp, 66);
        gd = new GridData();
        gd.widthHint = 380;
        this.message.setLayoutData((Object)gd);
        this.message.setEditable(false);
        this.message.setBackground(this.factory.getBackgroundColor());
    }

    private void updateTopSection(LogEntry entry) {
        this.date.setText(String.valueOf(PDERuntimePlugin.getResourceString("LogView.preview.date")) + " " + entry.getDate());
        this.eventType.setText(String.valueOf(PDERuntimePlugin.getResourceString("LogView.preview.type")) + " " + entry.getSeverityText());
        this.message.setText(entry.getMessage());
        Composite control = this.date.getParent();
        control.setRedraw(false);
        control.getParent().setRedraw(false);
        control.layout(true);
        control.getParent().layout(true);
        control.setRedraw(true);
        control.getParent().setRedraw(true);
    }

    public void dispose() {
        super.dispose();
        this.headingImage.dispose();
        this.unregisterSection(this.sessionSection);
        this.unregisterSection(this.stackSection);
    }

    public void saveState() {
        this.memento.putString("collapseSession", this.sessionSection.isCollapsed() ? "true" : "false");
        this.memento.putString("collapseStack", this.stackSection.isCollapsed() ? "true" : "false");
    }

    public boolean hasFocus() {
        return this.message.isFocusControl() || this.stackSection.hasFocus() || this.sessionSection.hasFocus();
    }
}

